/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.messaging.MonitoredNode;
import fi.csc.microarray.messaging.NodeBase;

public abstract class MonitoredNodeBase
extends NodeBase
implements MonitoredNode {
    private volatile long requestsInProcessing = 0L;
    private volatile long lastProcessingTime = 0L;

    public long countRequestsInProcessing() {
        return this.requestsInProcessing;
    }

    public long getLastProcessingTime() {
        return this.lastProcessingTime;
    }

    protected long requestProcessingStarted() {
        ++this.requestsInProcessing;
        return System.currentTimeMillis();
    }

    protected void requestProcessingStopped(long startTime) {
        --this.requestsInProcessing;
        this.lastProcessingTime = System.currentTimeMillis() - startTime;
    }
}

