/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.manager;

import fi.csc.microarray.ApplicationConstants;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.MonitoredNodeBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.JobLogMessage;
import fi.csc.microarray.messaging.message.NamiMessage;
import fi.csc.microarray.service.KeepAliveShutdownHandler;
import fi.csc.microarray.service.ShutdownCallback;
import fi.csc.microarray.util.MemUtil;
import it.sauronsoftware.cron4j.Scheduler;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.JMSException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.h2.tools.Server;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class Manager
extends MonitoredNodeBase
implements MessagingListener,
ShutdownCallback {
    private final Logger logger;
    private JdbcTemplate jdbcTemplate;
    private SimpleJdbcInsert insertJobTemplate;
    private static final String CREATE_JOBS_TABLE = "CREATE TABLE IF NOT EXISTS jobs (id VARCHAR(100) PRIMARY KEY, operation VARCHAR(100), status VARCHAR(100), starttime DATETIME DEFAULT NULL, endtime DATETIME DEFAULT NULL, wallclockTime INT DEFAULT NULL, errorMessage TEXT DEFAULT NULL, outputText TEXT DEFAULT NULL, username VARCHAR(200), compHost VARCHAR(200)); ";
    private MessagingEndpoint endpoint;

    public Manager() throws MicroarrayException, JMSException, IOException, ConfigurationLoader.IllegalConfigurationException, ClassNotFoundException, SQLException {
        DirectoryLayout.initialiseServerLayout(Arrays.asList("manager"));
        Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
        this.logger = Logger.getLogger(Manager.class);
        this.logger.info("starting manager...");
        String dbDriver = configuration.getString("manager", "jdbc-driver");
        String dbUrl = configuration.getString("manager", "database-url");
        boolean startWebConsole = configuration.getBoolean("manager", "start-web-console");
        String dbUsername = configuration.getString("manager", "database-username");
        String dbPassword = configuration.getString("manager", "database-password");
        int webConsolePort = configuration.getInt("manager", "web-console-port");
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName(dbDriver);
        dataSource.setUrl(dbUrl);
        dataSource.setUsername(dbUsername);
        dataSource.setPassword(dbPassword);
        this.jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        this.insertJobTemplate = new SimpleJdbcInsert((DataSource)dataSource).withTableName("jobs");
        this.jdbcTemplate.execute(CREATE_JOBS_TABLE);
        int backupInterval = configuration.getInt("manager", "backup-interval");
        String backupTimeString = configuration.getString("manager", "backup-time");
        int startHour = Integer.parseInt(backupTimeString.split(":")[0]);
        int startMinute = Integer.parseInt(backupTimeString.split(":")[1]);
        Calendar firstBackupTime = Calendar.getInstance();
        if (firstBackupTime.get(11) > startHour || firstBackupTime.get(11) == startHour && firstBackupTime.get(12) >= startMinute) {
            firstBackupTime.add(5, 1);
        }
        firstBackupTime.set(11, startHour);
        firstBackupTime.set(12, startMinute);
        firstBackupTime.set(13, 0);
        firstBackupTime.set(14, 0);
        this.logger.info("Next database backup is scheduled at " + firstBackupTime.getTime().toString());
        Timer timer = new Timer("chipster-manager-backup", true);
        File backupDir = DirectoryLayout.getInstance().getBackupDir();
        timer.scheduleAtFixedRate((TimerTask)new BackupTimerTask(backupDir), firstBackupTime.getTime(), (long)(backupInterval * 60 * 60 * 1000));
        TimerTask additionalTask = null;
        try {
            additionalTask = (TimerTask)Class.forName("fi.csc.chipster.manager.AskareLogTimerTask").getConstructor(JdbcTemplate.class).newInstance(this.jdbcTemplate);
        }
        catch (Exception e) {
            this.logger.info("could not load additional tasks");
        }
        if (additionalTask != null) {
            Scheduler scheduler = new Scheduler();
            scheduler.schedule("10 0 * * *", additionalTask);
            scheduler.start();
        }
        this.endpoint = new MessagingEndpoint(this);
        MessagingTopic managerTopic = this.endpoint.createTopic(Topics.Name.MANAGER_TOPIC, MessagingTopic.AccessMode.READ);
        managerTopic.setListener(this);
        if (startWebConsole) {
            Server server = Server.createWebServer((String[])new String[]{"-webAllowOthers", "-webPort", String.valueOf(webConsolePort)});
            server.start();
        }
        KeepAliveShutdownHandler.init(this);
        this.logger.error("manager is up and running [" + ApplicationConstants.NAMI_VERSION + "]");
        this.logger.info("[mem: " + MemUtil.getMemInfo() + "]");
    }

    public String getName() {
        return "manager";
    }

    public void onNamiMessage(NamiMessage namiMessage) {
        if (!(namiMessage instanceof JobLogMessage)) {
            this.logger.warn("Got other than JobLogMessage: " + namiMessage.toString());
            return;
        }
        JobLogMessage jobLogMessage = (JobLogMessage)namiMessage;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("id", jobLogMessage.getJobId());
            parameters.put("operation", jobLogMessage.getOperation());
            parameters.put("status", jobLogMessage.getState().toString());
            parameters.put("starttime", jobLogMessage.getStartTime());
            parameters.put("endtime", jobLogMessage.getEndTime());
            parameters.put("wallclockTime", (jobLogMessage.getEndTime().getTime() - jobLogMessage.getStartTime().getTime()) / 1000L);
            parameters.put("errorMessage", jobLogMessage.getErrorMessage());
            parameters.put("outputText", jobLogMessage.getOutputText());
            parameters.put("username", jobLogMessage.getUsername());
            parameters.put("compHost", jobLogMessage.getCompHost());
            this.insertJobTemplate.execute(parameters);
        }
        catch (Exception e) {
            this.logger.error("Could not insert log entry", e);
        }
    }

    public void shutdown() {
        this.logger.info("shutdown requested");
        try {
            this.endpoint.close();
        }
        catch (JMSException e) {
            this.logger.error("closing messaging endpoint failed", e);
        }
        this.logger.info("shutting down");
    }

    private class BackupTimerTask
    extends TimerTask {
        private File baseBackupDir;

        public BackupTimerTask(File backupDir) {
            this.baseBackupDir = backupDir;
        }

        public void run() {
            Manager.this.logger.info("Creating database backup");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_mm:ss.SSS");
            String fileName = this.baseBackupDir.getAbsolutePath() + File.separator + "chipster-manager-db-backup-" + df.format(new Date());
            String sql = "SCRIPT TO '" + fileName + ".zip' COMPRESSION ZIP";
            Manager.this.jdbcTemplate.execute(sql);
        }
    }
}

