/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.description;

import fi.csc.microarray.description.VVSADLSyntax;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedVVSADL {
    private String name;
    private String packageName;
    private String comment;
    private LinkedList<Input> inputs = new LinkedList();
    private LinkedList<String> outputs = new LinkedList();
    private LinkedList<Input> metaInputs = new LinkedList();
    private LinkedList<String> metaOutputs = new LinkedList();
    private LinkedList<Parameter> parameters = new LinkedList();

    public ParsedVVSADL(String name, String packageName, String comment) {
        this.name = name;
        this.packageName = packageName;
        this.comment = comment;
    }

    public void addInput(Input input) {
        this.inputs.add(input);
    }

    public void addMetaInput(Input input) {
        this.metaInputs.add(input);
    }

    public void addOutput(String metaOutput) {
        this.outputs.add(metaOutput);
    }

    public void addMetaOutput(String metaOutput) {
        this.metaOutputs.add(metaOutput);
    }

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getComment() {
        return this.comment;
    }

    public List<Input> inputs() {
        return this.inputs;
    }

    public List<Input> metaInputs() {
        return this.metaInputs;
    }

    public List<String> outputs() {
        return this.outputs;
    }

    public List<String> metaOutputs() {
        return this.metaOutputs;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public String toString() {
        String string = "ANALYSIS \"" + this.getPackageName() + "\"/\"" + this.getName() + "\" (" + this.getComment() + ")\n";
        string = string + this.toStringForInputs("INPUT", this.inputs());
        string = string + this.toStringForInputs("METAINPUT", this.metaInputs());
        string = string + this.toStringForOutputs("OUTPUT", this.outputs());
        string = string + this.toStringForOutputs("METAOUTPUT", this.metaOutputs());
        if (!this.parameters().isEmpty()) {
            for (Parameter parameter : this.parameters()) {
                String paramString = "PARAMETER " + parameter.getName() + " ";
                if (parameter.getType() == VVSADLSyntax.ParameterType.ENUM) {
                    paramString = paramString + "[";
                    boolean first = true;
                    for (String option : parameter.getSelectionOptions()) {
                        if (!first) {
                            paramString = paramString + ", ";
                        } else {
                            first = false;
                        }
                        paramString = paramString + option;
                    }
                    paramString = paramString + "] ";
                } else {
                    paramString = paramString + (Object)((Object)parameter.getType()) + " ";
                    if (parameter.getFrom() != null) {
                        paramString = paramString + "FROM " + parameter.getFrom() + " ";
                    }
                    if (parameter.getTo() != null) {
                        paramString = paramString + "TO " + parameter.getTo() + " ";
                    }
                }
                if (parameter.getDefaultValue() != null) {
                    paramString = paramString + "DEFAULT " + parameter.getDefaultValue() + " ";
                }
                paramString = paramString + "(" + parameter.getComment() + ")";
                string = string + paramString + "\n";
            }
        }
        return string;
    }

    private String toStringForOutputs(String header, List<String> outputList) {
        String string = "";
        if (!outputList.isEmpty()) {
            String outputString = header + " ";
            boolean first = true;
            for (String output : outputList) {
                if (!first) {
                    outputString = outputString + ", ";
                } else {
                    first = false;
                }
                outputString = outputString + output;
            }
            string = string + outputString + "\n";
        }
        return string;
    }

    private String toStringForInputs(String header, List<Input> inputList) {
        String string = "";
        if (!inputList.isEmpty()) {
            String inputString = header + " ";
            boolean first = true;
            for (Input input : inputList) {
                if (!first) {
                    inputString = inputString + ", ";
                } else {
                    first = false;
                }
                inputString = inputString + input.getType().getName() + " ";
                if (input.isInputSet()) {
                    inputString = inputString + input.getPrefix() + "[...]" + input.getPostfix();
                    continue;
                }
                inputString = inputString + input.getName();
            }
            string = string + inputString + "\n";
        }
        return string;
    }

    public void addInputs(List<Input> inputCollection) {
        this.inputs.addAll(inputCollection);
    }

    public void addMetaInputs(List<Input> inputCollection) {
        this.metaInputs.addAll(inputCollection);
    }

    public void addOutputs(List<String> outputCollection) {
        this.outputs.addAll(outputCollection);
    }

    public void addMetaOutputs(List<String> outputCollection) {
        this.metaOutputs.addAll(outputCollection);
    }

    public static class Parameter {
        private String name;
        private VVSADLSyntax.ParameterType type;
        private String[] selectionOptions;
        private String from;
        private String to;
        private String defaultValue;
        private String comment;

        public Parameter(String name, VVSADLSyntax.ParameterType type, String[] selectionOptions, String from, String to, String defaultValue, String comment) {
            this.name = name;
            this.type = type;
            this.selectionOptions = selectionOptions;
            this.from = from;
            this.to = to;
            this.defaultValue = defaultValue;
            this.comment = comment;
        }

        public String getName() {
            return this.name;
        }

        public VVSADLSyntax.ParameterType getType() {
            return this.type;
        }

        public String[] getSelectionOptions() {
            return this.selectionOptions;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getComment() {
            return this.comment;
        }
    }

    public static class Input {
        private VVSADLSyntax.InputType type;
        private String name;
        private String prefix;
        private String postfix;

        public static Input createInput(VVSADLSyntax.InputType type, String name) {
            return new Input(type, name, null, null);
        }

        public static Input createInputSet(VVSADLSyntax.InputType type, String prefix, String postfix) {
            return new Input(type, null, prefix, postfix);
        }

        private Input(VVSADLSyntax.InputType type, String name, String prefix, String postfix) {
            this.type = type;
            this.name = name;
            this.prefix = prefix;
            this.postfix = postfix;
        }

        public VVSADLSyntax.InputType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getPostfix() {
            return this.postfix;
        }

        public boolean isInputSet() {
            return this.name == null;
        }
    }
}

