/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;

public class DislocationGenerator {
    private static final int MAX_BP = 247179968;

    public static void main(String[] args) {
        System.out.println("File generating started");
        Long startTime = System.currentTimeMillis();
        File file = new File("dislocations.fsf");
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            Random rand = new Random();
            int i = 0;
            int b = 0;
            while (b < 247179968) {
                long length = (long)Math.abs(rand.nextGaussian() * 1024.0);
                String id = "id" + i;
                String fromStart = "" + b;
                String fromEnd = "" + ((long)b + length);
                long toStart = (long)((double)b + rand.nextGaussian() * 2.47179968E8 / 1028.0);
                String toEnd = "" + (toStart + length);
                if (b > 0 && toStart > 0L && toStart < 247179968L) {
                    id = DislocationGenerator.fillWithSpaces(id, 16);
                    fromStart = DislocationGenerator.fillWithSpaces(fromStart, 16);
                    fromEnd = DislocationGenerator.fillWithSpaces(fromEnd, 16);
                    String toStartStr = DislocationGenerator.fillWithSpaces("" + toStart, 16);
                    String toEndStr = DislocationGenerator.fillWithSpaces("" + toEnd, 50);
                    writer.write(id + fromStart + fromEnd + toStartStr + toEndStr + "\n");
                }
                if (i % 100000 == 0) {
                    System.out.println("" + (int)((float)b / 2.4717997E8f * 100.0f) + " % ");
                }
                b = (double)rand.nextFloat() > 0.01 ? (int)((double)b + Math.pow(rand.nextGaussian(), 2.0) * 1024.0) : (int)((double)b + rand.nextGaussian() * 1024.0 * 1024.0);
                ++i;
            }
            writer.flush();
            writer.close();
            System.out.println("DONE in " + (System.currentTimeMillis() - startTime) / 1000L + " seconds");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getRandomChar(Random rand) {
        int r = rand.nextInt(4);
        switch (r) {
            case 0: {
                return "A";
            }
            case 1: {
                return "T";
            }
            case 2: {
                return "G";
            }
            case 3: {
                return "C";
            }
        }
        return null;
    }

    private static String fillWithSpaces(String orig, int length) {
        String spaces = "                                                                          ";
        return orig + spaces.substring(0, length - orig.length());
    }
}

