/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.track;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.View;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Content;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ReadInstructions;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.track.Track;
import java.awt.Color;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntensityTrack
extends Track {
    private TreeMap<Region, Float> values = new TreeMap();
    private long minBpLength;
    private Color color;

    public IntensityTrack(View view, File file, Class<? extends AreaRequestHandler> handler, ReadInstructions<?> readInstructions, Color c, long maxBpLength) {
        super(view, file, handler, readInstructions);
        this.color = c;
        this.minBpLength = maxBpLength;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        for (Map.Entry<Region, Float> value : this.values.entrySet()) {
            Region reg = value.getKey();
            int x1 = this.getView().bpToTrack(reg.start);
            int x2 = this.getView().bpToTrack(reg.end);
            int y2 = (int)this.getView().getTrackHeight();
            int val = (int)Math.min(Math.log(value.getValue().floatValue() * 10.0f) * 5.0, (double)(this.getView().getTrackHeight() / 4.0f));
            int y1 = -val + y2;
            drawables.add(new RectDrawable(x1, y1, x2 - x1, y2 - y1, this.color, null));
        }
        return drawables;
    }

    @Override
    public void updateData() {
        this.values.clear();
        super.updateData();
    }

    @Override
    public void processAreaResult(AreaResult<RegionContent> areaResult) {
        if (((RegionContent)areaResult.content).values.containsKey((Object)Content.VALUE)) {
            this.values.put(((RegionContent)areaResult.content).region, (Float)((RegionContent)areaResult.content).values.get((Object)Content.VALUE));
            this.getView().redraw();
        }
    }

    @Override
    public int getMaxHeight() {
        if (this.getView().getBpRegion().getLength() > this.minBpLength) {
            return super.getMaxHeight();
        }
        return 0;
    }

    @Override
    public Collection<Content> getDefaultContents() {
        return Arrays.asList(new Content[0]);
    }

    @Override
    public boolean isConcised() {
        return true;
    }
}

