/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Chunker;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ConstantLengthChunkParser;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.Region;

public class ConstantLengthChunker
extends Chunker {
    private ConstantLengthChunkParser parser;

    public ConstantLengthChunker(ConstantLengthChunkParser parser) {
        this.parser = parser;
    }

    public int getChunkByteLength() {
        return (int)this.parser.getRowLength() * 32;
    }

    public long getFilePosition(long readIndex) {
        return readIndex * this.parser.getRowLength();
    }

    public long getReadIndex(long filePosition) {
        return filePosition / this.parser.getRowLength();
    }

    public Region getChunkMiddleOf(Region readIndexes) {
        Region nodeRows = new Region();
        nodeRows.start = (long)Math.ceil(readIndexes.getMid() / (long)this.getChunkReadLength()) * (long)this.getChunkReadLength();
        nodeRows.end = nodeRows.start + (long)this.getChunkReadLength() - 1L;
        return nodeRows;
    }

    public int getChildCount(Region subtreeReadIndexes) {
        if (subtreeReadIndexes.getLength() <= (long)this.getChunkReadLength()) {
            return 0;
        }
        if (subtreeReadIndexes.getLength() <= (long)(this.getChunkReadLength() * 2)) {
            return 1;
        }
        return 2;
    }

    public int getChunkReadLength() {
        return (int)((long)this.getChunkByteLength() / this.parser.getRowLength());
    }
}

