/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ChunkParser;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Content;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.DataFieldDef;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.FileDefinition;

public class ConstantLengthChunkParser
extends ChunkParser {
    private long rowLength;

    public ConstantLengthChunkParser(FileDefinition fileDef) {
        super(fileDef);
        for (DataFieldDef col : fileDef) {
            col.offset = this.rowLength;
            this.rowLength += (long)col.length;
        }
    }

    public float getFloat(long pos) {
        return new Float(this.getString(pos)).floatValue();
    }

    public long getLong(long pos) {
        String str = this.getString(pos).trim();
        if (!str.equals("")) {
            return new Long(str);
        }
        return Long.MIN_VALUE;
    }

    public long getPosition(long readIndex, Content rec) {
        return readIndex * (long)this.fileDef.size() + (long)this.fileDef.indexOf(rec);
    }

    public long getReadCount() {
        return this.chunk.length / this.rowLength;
    }

    public String getString(long pos) {
        return new String(this.getBytes(pos));
    }

    private byte[] getBytes(long pos) {
        long row = pos / (long)this.fileDef.size() - this.chunk.readIndex;
        int colIndex = (int)(pos % (long)this.fileDef.size());
        byte[] byteValue = new byte[((DataFieldDef)this.fileDef.get((int)colIndex)).length];
        System.arraycopy(this.chunk.content, (int)(row * this.rowLength + ((DataFieldDef)this.fileDef.get((int)colIndex)).offset), byteValue, 0, byteValue.length);
        return byteValue;
    }

    public long getRowLength() {
        return this.rowLength;
    }

    public ChunkParser clone() {
        return new ConstantLengthChunkParser(this.fileDef);
    }
}

