/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.GenomeBrowser;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.RegionListener;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.QueueManager;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.track.RulerTrack;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.track.Track;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class View
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected Region bpRegion;
    public Region highlight;
    public Collection<Track> tracks = new LinkedList<Track>();
    protected Rectangle viewArea = new Rectangle(0, 0, 500, 500);
    private QueueManager queueManager = new QueueManager();
    private Point2D dragStartPoint;
    private boolean dragStarted;
    GenomeBrowser parentPlot;
    private static final int FPS = 30;
    private boolean movable;
    protected boolean zoomable;
    private boolean selectable;
    protected final float ZOOM_FACTOR = 1.03f;
    private List<RegionListener> listeners = new LinkedList<RegionListener>();
    public int margin = 0;
    protected Float trackHeight;
    private Point2D dragEndPoint;
    private Point2D dragLastStartPoint;
    private Iterator<Track> trackIter;
    private Iterator<Drawable> drawableIter;
    private boolean continueDrawingLater;
    private Track track;
    private float y;
    private int x;
    private BufferedImage drawBuffer;
    private Timer timer;
    private int timerCounter;

    public View(GenomeBrowser parent, boolean movable, boolean zoomable, boolean selectable) {
        this.parentPlot = parent;
        this.movable = movable;
        this.zoomable = zoomable;
        this.selectable = selectable;
    }

    public void addTrack(Track t) {
        this.tracks.add(t);
    }

    protected void drawView(Graphics2D g, boolean isAnimation) {
        Graphics2D bufG2;
        Rectangle viewClip;
        if (this.bpRegion == null) {
            this.setBpRegion(new Region(0L, 0xFA00000L), false);
        }
        this.viewArea = viewClip = g.getClipBounds();
        if (this.drawBuffer == null) {
            this.drawBuffer = new BufferedImage((int)this.viewArea.getWidth(), (int)this.viewArea.getHeight(), 1);
            bufG2 = (Graphics2D)this.drawBuffer.getGraphics();
            bufG2.setPaint(Color.white);
            bufG2.fillRect(0, 0, this.drawBuffer.getWidth(), this.drawBuffer.getHeight());
        }
        bufG2 = (Graphics2D)this.drawBuffer.getGraphics();
        if (this.trackIter == null) {
            this.y = 0.0f;
            this.x = 0;
            this.trackIter = this.tracks.iterator();
            this.drawableIter = null;
        }
        long startTime = System.currentTimeMillis();
        this.continueDrawingLater = false;
        while (this.trackIter.hasNext() || this.drawableIter != null && this.drawableIter.hasNext()) {
            if (this.drawableIter == null || !this.drawableIter.hasNext()) {
                this.track = this.trackIter.next();
            }
            if (this.track.getMaxHeight() > 0) {
                if (this.drawableIter == null) {
                    Collection<Drawable> drawables = this.track.getDrawables();
                    this.drawableIter = drawables.iterator();
                }
                while (this.drawableIter.hasNext()) {
                    Drawable drawable = this.drawableIter.next();
                    int maybeReversedY = (int)this.y;
                    if (this.track.isReversed()) {
                        drawable.upsideDown();
                        maybeReversedY = (int)((float)maybeReversedY + Math.min(this.getTrackHeight(), (float)this.track.getMaxHeight()));
                    }
                    this.drawDrawable(bufG2, this.x, maybeReversedY, drawable);
                    if (System.currentTimeMillis() - startTime < 33L) continue;
                    this.continueDrawingLater = true;
                    this.redraw();
                    break;
                }
                if (this.continueDrawingLater) break;
                this.drawableIter = null;
            }
            if (this.track.getMaxHeight() == Integer.MAX_VALUE) {
                this.y += this.getTrackHeight();
                continue;
            }
            this.y += (float)this.track.getMaxHeight();
        }
        g.drawImage(this.drawBuffer, (int)this.viewArea.getX(), (int)this.viewArea.getY(), (int)this.viewArea.getX() + this.drawBuffer.getWidth(), (int)this.viewArea.getY() + this.drawBuffer.getHeight(), 0, 0, this.drawBuffer.getWidth(), this.drawBuffer.getHeight(), null);
        if (!this.continueDrawingLater) {
            bufG2.setPaint(Color.white);
            bufG2.fillRect(0, 0, this.drawBuffer.getWidth(), this.drawBuffer.getHeight());
            this.trackIter = null;
            this.drawableIter = null;
        }
    }

    protected abstract void drawDrawable(Graphics2D var1, int var2, int var3, Drawable var4);

    public float getTrackHeight() {
        if (this.trackHeight == null) {
            this.trackHeight = Float.valueOf((float)(this.getHeight() - this.getMaxTrackHeightTotal()) / (float)this.getStretchableTrackCount());
        }
        return this.trackHeight.floatValue();
    }

    protected int getMaxTrackHeightTotal() {
        int maxHeightTotal = 0;
        for (Track track : this.tracks) {
            if (track.getMaxHeight() == Integer.MAX_VALUE) continue;
            maxHeightTotal += track.getMaxHeight();
        }
        return maxHeightTotal;
    }

    protected int getStretchableTrackCount() {
        int stretchableCount = 0;
        for (Track track : this.tracks) {
            if (track.getMaxHeight() != Integer.MAX_VALUE) continue;
            ++stretchableCount;
        }
        return stretchableCount;
    }

    public int getWidth() {
        return this.viewArea.width;
    }

    public int getHeight() {
        return this.viewArea.height;
    }

    public QueueManager getQueueManager() {
        return this.queueManager;
    }

    public void setBpRegion(Region region, boolean disableDrawing) {
        this.bpRegion = region;
        this.trackHeight = null;
        if (!disableDrawing) {
            for (Track t : this.tracks) {
                t.updateData();
            }
            this.dispatchRegionChange();
        }
    }

    public Region getBpRegion() {
        return this.bpRegion;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.stopAnimation();
        this.dragStartPoint = this.scale(e.getPoint());
        this.dragStarted = false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.dragStarted && this.dragEndPoint != null && this.dragLastStartPoint != null && Math.abs(this.dragEndPoint.getX() - this.dragLastStartPoint.getX()) > 10.0) {
            this.stopAnimation();
            this.timer = new Timer(33, new ActionListener(){
                private int i = 0;
                private int ANIMATION_FRAMES = 30;
                private long startTime = System.currentTimeMillis();

                public void actionPerformed(ActionEvent arg0) {
                    boolean skipFrame;
                    double endX = View.this.dragEndPoint.getX();
                    double startX = View.this.dragLastStartPoint.getX();
                    double newX = endX - (endX - startX) / (double)(this.ANIMATION_FRAMES - this.i);
                    View.this.dragEndPoint = new Point2D.Double(newX, View.this.dragEndPoint.getY());
                    boolean bl = skipFrame = this.i < this.ANIMATION_FRAMES - 1 && System.currentTimeMillis() > this.startTime + (long)(33 * this.i);
                    if (this.i < this.ANIMATION_FRAMES) {
                        View.this.handleDrag(View.this.dragLastStartPoint, View.this.dragEndPoint, skipFrame);
                        ++this.i;
                    } else {
                        View.this.stopAnimation();
                    }
                }
            });
            this.timer.setRepeats(true);
            this.timer.start();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.movable) {
            this.dragStarted = true;
            this.dragEndPoint = this.scale(e.getPoint());
            this.handleDrag(this.dragStartPoint, this.dragEndPoint, false);
        }
        this.dragLastStartPoint = this.dragStartPoint;
        this.dragStartPoint = this.scale(e.getPoint());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    protected abstract void handleDrag(Point2D var1, Point2D var2, boolean var3);

    @Override
    public void mouseWheelMoved(final MouseWheelEvent e) {
        this.stopAnimation();
        this.timer = new Timer(33, new ActionListener(){
            private int i = 0;
            private long startTime = System.currentTimeMillis() + 100L;
            private int ANIMATION_FRAMES = 15;

            public void actionPerformed(ActionEvent arg0) {
                boolean skipFrame;
                boolean bl = skipFrame = this.i < this.ANIMATION_FRAMES - 1 && System.currentTimeMillis() > this.startTime + (long)(33 * this.i);
                if (this.i < this.ANIMATION_FRAMES) {
                    View.this.zoom((int)View.this.scale(e.getPoint()).getX(), e.getWheelRotation(), skipFrame);
                    ++this.i;
                } else {
                    View.this.stopAnimation();
                }
            }
        });
        this.timer.setRepeats(true);
        this.timer.setCoalesce(false);
        this.timer.start();
    }

    private void stopAnimation() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    private void zoom(int lockedX, int wheelRotation, boolean disableDrawing) {
        if (this.zoomable) {
            if (wheelRotation > 0) {
                lockedX = this.getWidth() - lockedX + this.getX() * 2;
            }
            double pointerBp = this.trackToBp(lockedX);
            double pointerRelative = this.trackToRelative(lockedX);
            long startBp = this.getBpRegion().start;
            long endBp = this.getBpRegion().end;
            double width = endBp - startBp;
            startBp = (long)(pointerBp - (width *= Math.pow(1.03f, wheelRotation)) * pointerRelative);
            endBp = (long)(pointerBp + width * (1.0 - pointerRelative));
            if (startBp < 0L) {
                endBp += -startBp;
                startBp = 0L;
            }
            this.setBpRegion(new Region(startBp, endBp), disableDrawing);
        }
    }

    public int bpToTrack(long bp) {
        return (int)(((double)bp - (double)this.getBpRegion().start.longValue()) / (double)(this.getBpRegion().end - this.getBpRegion().start) * (double)this.getWidth()) + this.getX();
    }

    public long trackToBp(long d) {
        return (long)(this.trackToRelative(d) * (double)(this.getBpRegion().end - this.getBpRegion().start) + (double)this.getBpRegion().start.longValue());
    }

    public double trackToRelative(long track) {
        return (double)(track - (long)this.getX()) / (double)this.getWidth();
    }

    public int getX() {
        return this.viewArea.x;
    }

    public int getY() {
        return this.viewArea.y;
    }

    public void redraw() {
        this.parentPlot.redraw();
    }

    public List<Long> getRulerInfo() {
        for (Track t : this.tracks) {
            if (!(t instanceof RulerTrack)) continue;
            RulerTrack ruler = (RulerTrack)t;
            return ruler.getRulerInfo();
        }
        return null;
    }

    public void addRegionListener(RegionListener listener) {
        this.listeners.add(listener);
    }

    public void dispatchRegionChange() {
        for (RegionListener listener : this.listeners) {
            listener.RegionChanged(this.bpRegion);
        }
    }

    private Point2D scale(Point2D p) {
        return new Point((int)(p.getX() / this.parentPlot.chartPanel.getScaleX()), (int)(p.getY() / this.parentPlot.chartPanel.getScaleY()));
    }
}

