/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.methods.ArrayLayout;
import fi.csc.microarray.client.visualisation.methods.ClusteredProfiles;
import fi.csc.microarray.client.visualisation.methods.Empty;
import fi.csc.microarray.client.visualisation.methods.ExpressionProfile;
import fi.csc.microarray.client.visualisation.methods.HierarchicalClustering;
import fi.csc.microarray.client.visualisation.methods.Histogram;
import fi.csc.microarray.client.visualisation.methods.HtmlViewer;
import fi.csc.microarray.client.visualisation.methods.ImageViewer;
import fi.csc.microarray.client.visualisation.methods.PhenodataEditor;
import fi.csc.microarray.client.visualisation.methods.SOM;
import fi.csc.microarray.client.visualisation.methods.Scatterplot;
import fi.csc.microarray.client.visualisation.methods.Scatterplot3DPCA;
import fi.csc.microarray.client.visualisation.methods.Spreadsheet;
import fi.csc.microarray.client.visualisation.methods.TextViewer;
import fi.csc.microarray.client.visualisation.methods.VennDiagram;
import fi.csc.microarray.client.visualisation.methods.Volcanoplot;
import fi.csc.microarray.client.visualisation.methods.threed.Scatterplot3D;
import fi.csc.microarray.databeans.DataBean;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum VisualisationMethod {
    NONE("None                                   ", Empty.class, VisualConstants.EMPTY_MENUICON, 0, 0.0),
    SPREADSHEET("Spreadsheet", Spreadsheet.class, VisualConstants.SPREADSHEET_MENUICON, 2, 7.0E-4),
    PHENODATA("Phenodata editor", PhenodataEditor.class, VisualConstants.PHENODATA_MENUICON, 3, 0.0),
    ARRAY_LAYOUT("Array layout", ArrayLayout.class, VisualConstants.ARRAY_MENUICON, -1, 9.0E-4),
    HISTOGRAM("Histogram", Histogram.class, VisualConstants.HISTOGRAM_MENUICON, -1, 0.024),
    SCATTERPLOT("Scatterplot", Scatterplot.class, VisualConstants.SCATTER_MENUICON, -1, 0.039),
    SCATTERPLOT3D("3D Scatterplot", Scatterplot3D.class, VisualConstants.SCATTER3D_MENUICON, -1, 0.082),
    SCATTERPLOT3DPCA("3D Scatterplot for PCA", Scatterplot3DPCA.class, VisualConstants.SCATTER3DPCA_MENUICON, -1, 0.082),
    VOLCANOPLOT("Volcano plot", Volcanoplot.class, VisualConstants.VOLCANO_MENUICON, -1, 0.039),
    SOM("SOM", SOM.class, VisualConstants.SOM_MENUICON, 3, 0.034),
    HIERARCHICAL("Hierarchical clustering", HierarchicalClustering.class, VisualConstants.HC_MENUICON, 3, 0.09),
    EXPRESSION_PROFILE("Expression profile", ExpressionProfile.class, VisualConstants.PROFILE_MENUICON, -1, 0.1),
    CLUSTERED_PROFILES("Clustered profiles", ClusteredProfiles.class, VisualConstants.PROFILES_MENUICON, -1, 0.087),
    SHOW_IMAGE("Show image", ImageViewer.class, VisualConstants.IMAGE_MENUICON, 1, 0.015),
    WEBVIEW("View page", HtmlViewer.class, VisualConstants.HTML_MENUICON, 1, 0.008),
    VIEW_TEXT("View text", TextViewer.class, VisualConstants.TEXT_MENUICON, 1, 0.023),
    VENN_DIAGRAM("Venn-diagram", VennDiagram.class, VisualConstants.VENN_MENUICON, 1, 0.0);

    private static LinkedList<VisualisationMethod> orderedDefaultCandidates;
    private final ClientApplication application = Session.getSession().getApplication();
    private String name;
    private Class<? extends Visualisation> visualiser;
    private ImageIcon icon;
    private int orderNumber;
    private double durationEstimationFactor;
    Map<DataBean, Boolean> canVisualiseCache = new HashMap<DataBean, Boolean>();

    private VisualisationMethod(String name, Class<? extends Visualisation> visualiser, ImageIcon icon, int orderNumber, double durationEstimationFactor) {
        this.name = name;
        this.visualiser = visualiser;
        this.icon = icon;
        this.orderNumber = orderNumber;
        this.durationEstimationFactor = durationEstimationFactor;
    }

    public String toString() {
        return this.name;
    }

    public Class<? extends Visualisation> getVisualiserClass() {
        return this.visualiser;
    }

    public Visualisation getVisualiser(VisualisationFrame frame) {
        try {
            return this.visualiser.getConstructor(VisualisationFrame.class).newInstance(frame);
        }
        catch (Exception e) {
            this.application.reportException(e);
            return null;
        }
    }

    public Visualisation getHeadlessVisualiser() {
        try {
            return this.visualiser.getConstructor(VisualisationFrame.class).newInstance(new Object[]{null});
        }
        catch (Exception e) {
            this.application.reportException(e);
            return null;
        }
    }

    public int getOrderNumber() {
        return this.orderNumber;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public static VisualisationMethod getDefault() {
        return NONE;
    }

    public long estimateDuration(List<DataBean> datas) {
        if (datas.size() > 0) {
            return (long)((double)datas.get(0).getContentLength() * this.durationEstimationFactor * (double)datas.size());
        }
        return -1L;
    }

    public boolean isApplicableTo(DataBean bean) throws MicroarrayException {
        if (bean != null) {
            Boolean result = this.canVisualiseCache.get(bean);
            if (result == null) {
                result = this.getHeadlessVisualiser().canVisualise(bean);
                this.canVisualiseCache.put(bean, result);
            }
            return result;
        }
        return false;
    }

    public boolean isApplicableTo(List<DataBean> beans) throws MicroarrayException {
        if (!this.getHeadlessVisualiser().isForMultipleDatas()) {
            return false;
        }
        return this.getHeadlessVisualiser().canVisualise(beans);
    }

    public static Iterable<VisualisationMethod> orderedDefaultCandidates() {
        return orderedDefaultCandidates;
    }

    public static VisualisationMethod getDefaultVisualisationFor(DataBean dataBean) throws IOException, MicroarrayException {
        for (VisualisationMethod method : VisualisationMethod.orderedDefaultCandidates()) {
            if (method == NONE || !method.isApplicableTo(dataBean)) continue;
            return method;
        }
        return null;
    }

    static {
        orderedDefaultCandidates = new LinkedList();
        for (VisualisationMethod value : VisualisationMethod.values()) {
            if (value.getOrderNumber() < 0) continue;
            orderedDefaultCandidates.add(value);
        }
        Collections.sort(orderedDefaultCandidates, new Comparator<VisualisationMethod>(){

            @Override
            public int compare(VisualisationMethod method1, VisualisationMethod method2) {
                return new Integer(method2.getOrderNumber()).compareTo(new Integer(method1.getOrderNumber()));
            }
        });
    }
}

