/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationUtilities;
import fi.csc.microarray.databeans.DataBean;
import java.util.Arrays;

public abstract class ChipVisualisation
extends Visualisation {
    public ChipVisualisation(VisualisationFrame frame) {
        super(frame);
    }

    public Visualisation.Variable[] getVariablesFor(DataBean dataBean) {
        return VisualisationUtilities.getVariablesFilteredInclusive(dataBean, "chip.", true);
    }

    public Visualisation.Variable[] getVariablesMore(DataBean dataBean) {
        String[] banList = new String[]{" ", "symbol", "description", "Probe", "Symbol", "Description", "Chromosome", "GenBank", "Cytoband", "UniGene", "PubMed", "GeneOntology", "Pathway", "flag.", "Gene", "Gene.Ontology"};
        return VisualisationUtilities.getVariablesFilteredExclusive(dataBean, Arrays.asList(banList), true);
    }

    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        boolean isTabular = VisualisationMethod.SPREADSHEET.getHeadlessVisualiser().canVisualise(bean);
        return isTabular && this.hasRows(bean) && bean.queryFeatures("/column/chip.*").exists();
    }

    protected boolean hasRows(DataBean dataBean) throws MicroarrayException {
        return dataBean.queryFeatures("/rowcount/max/1").asFloat().floatValue() >= 1.0f;
    }
}

