/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.operation.parameter.ParameterInputComponent;
import fi.csc.microarray.client.operation.parameter.ParameterPanel;
import fi.csc.microarray.client.operation.parameter.StringParameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class StringInputComponent
extends ParameterInputComponent
implements CaretListener,
FocusListener,
DocumentListener {
    private StringParameter parameter;
    private JTextField field;

    protected StringInputComponent(StringParameter parameter, ParameterPanel parent) {
        super(parent);
        this.parameter = parameter;
        this.field = new JTextField();
        this.field.setPreferredSize(ParameterInputComponent.PREFERRED_SIZE);
        this.field.setText("" + parameter.getValue());
        this.field.addCaretListener(this);
        this.field.addFocusListener(this);
        this.field.getDocument().addDocumentListener(this);
        this.add((Component)this.field, "Center");
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public boolean inputIsValid() {
        return true;
    }

    public void caretUpdate(CaretEvent e) {
        this.getParentPanel().setMessage(this.parameter.getDescription(), Color.black);
    }

    private void updateParameter() {
        this.parameter.setValue(this.field.getText());
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateParameter();
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateParameter();
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateParameter();
    }

    public JComponent getParameterComponent() {
        return this.field;
    }
}

