/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataview;

import com.jgoodies.looks.HeaderStyle;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.ToolBarComponentFactory;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.dataview.AnimatorScrollable;
import fi.csc.microarray.client.dataview.MicroarrayGraph;
import fi.csc.microarray.client.dataviews.vertexes.AbstractGraphVertex;
import fi.csc.microarray.client.dataviews.vertexes.GraphRenderer;
import fi.csc.microarray.client.dataviews.vertexes.GraphVertex;
import fi.csc.microarray.client.dataviews.vertexes.GroupVertex;
import fi.csc.microarray.client.selection.DatasetChoiceEvent;
import fi.csc.microarray.client.visualisation.VisualisationFrameManager;
import fi.csc.microarray.databeans.ContentChangedEvent;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataChangeEvent;
import fi.csc.microarray.databeans.DataChangeListener;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataItemCreatedEvent;
import fi.csc.microarray.databeans.LinksChangedEvent;
import fi.csc.microarray.util.SwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexView;

public class GraphPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
DataChangeListener,
AnimatorScrollable {
    public final float ZOOM_FACTOR = 1.2f;
    public final float ZOOM_IN_LIMIT = 1.0f;
    public final float ZOOM_OUT_LIMIT = 0.2f;
    private MicroarrayGraph graph = null;
    private ClientApplication application = Session.getSession().getApplication();
    private GraphModel model = new DefaultGraphModel();
    private JScrollPane graphScroller = null;
    private JToolBar buttonToolBar = null;
    private JButton zoomInButton;
    private JButton zoomOutButton;
    private JCheckBox autoZoomChecBbox;
    private JButton historyButton;
    private boolean internalSelection = false;
    private static final Logger logger = Logger.getLogger(GraphPanel.class);
    private static final double DEFAULT_GRID_SIZE = 10.0;
    private static final double BIGGER_GRID_SIZE = 20.0;
    private static final double HUGE_GRID_SIZE = 40.0;
    private Point center;

    public void setInternalSelection(boolean internalSelection) {
        this.internalSelection = internalSelection;
    }

    public GraphPanel() {
        this.getGraph().getSelectionModel().addGraphSelectionListener(new WorkflowSelectionListener());
        this.getGraph().setMarqueeHandler(new BasicMarqueeHandler());
        this.setMinimumSize(new Dimension(0, 0));
        this.setLayout(new GridBagLayout());
        this.buttonToolBar = this.getButtonToolBar();
        this.graphScroller = this.getGraphScroller();
        this.setPreferredSize(new Dimension(360, 240));
        this.graphScroller.setPreferredSize(new Dimension(360, 240));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 15;
        c.gridy = 1;
        this.add((Component)this.buttonToolBar, c);
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 1;
        c.anchor = 11;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.graphScroller, c);
        this.application.addPropertyChangeListener(this);
        this.application.getDataManager().addDataChangeListener(this);
        this.graph.setCursor(Cursor.getPredefinedCursor(0));
        this.graph.setScale(this.graph.getScale() / (double)1.2f);
        VertexView.renderer = new GraphRenderer();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.zoomInButton) {
            this.autoZoomChecBbox.setSelected(false);
            this.zoomInToolUsed();
        } else if (source == this.zoomOutButton) {
            this.autoZoomChecBbox.setSelected(false);
            this.zoomOutToolUsed();
        } else if (source == this.autoZoomChecBbox) {
            this.autoZoom();
        } else if (source == this.historyButton) {
            this.application.showHistoryScreenFor(this.application.getSelectionManager().getSelectedDataBean());
        }
    }

    public void autoZoom() {
        if (this.autoZoomChecBbox.isSelected()) {
            double yScale;
            Dimension dim = this.graph.getGraphSize();
            double xScale = this.graphScroller.getSize().getWidth() / (double)dim.width;
            if (xScale < (yScale = this.graphScroller.getSize().getHeight() / (double)dim.height)) {
                this.setGraphScale(xScale);
            } else {
                this.setGraphScale(yScale);
            }
            this.updateGridSize();
            logger.debug("Graph size: " + dim.width + " , " + dim.height + " Scroller size: " + this.graphScroller.getSize().getWidth() + " , " + this.graphScroller.getSize().getHeight() + " Scales: " + xScale + " , " + yScale);
            this.graph.repaint();
        }
    }

    public MicroarrayGraph getGraph() {
        if (this.graph == null) {
            DefaultCellViewFactory factory = new DefaultCellViewFactory();
            boolean partial = true;
            GraphLayoutCache cache = new GraphLayoutCache(this.model, factory, partial);
            this.graph = new MicroarrayGraph(this.model, cache, this);
            this.graph.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                public void mouseReleased(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                public void mouseClicked(MouseEvent e) {
                    logger.debug("mouseClicked");
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
                        GraphPanel.this.graph.setCursor(Cursor.getDefaultCursor());
                        GraphPanel.this.mouseButtonDoubleClicked(e);
                    }
                }

                private void maybeShowPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        GraphPanel.this.showPopupMenu(e);
                    }
                }
            });
            this.graph.setAntiAliased(true);
            this.graph.setBendable(false);
            this.graph.setConnectable(false);
            this.graph.setDisconnectable(false);
            this.graph.setEditable(false);
            this.graph.setMoveable(true);
            this.graph.setPortsVisible(false);
            this.graph.setSizeable(false);
            this.graph.setGridColor(Color.LIGHT_GRAY);
            this.graph.setGridSize(10.0);
            this.graph.setGridVisible(true);
            this.graph.setGridEnabled(true);
        }
        return this.graph;
    }

    private void mouseButtonDoubleClicked(MouseEvent e) {
        Object cell = this.graph.getFirstCellForLocation(e.getX(), e.getY());
        logger.debug("Selected cell: " + cell);
        if (cell instanceof GraphVertex) {
            this.application.visualiseWithBestMethod(VisualisationFrameManager.FrameType.MAIN);
        }
    }

    protected GraphModel getGraphModel() {
        return this.model;
    }

    private JScrollPane getGraphScroller() {
        if (this.graphScroller == null) {
            this.graphScroller = new JScrollPane(this.getGraph());
            this.graphScroller.setBorder(BorderFactory.createEmptyBorder());
            this.graphScroller.setMinimumSize(new Dimension(0, 0));
            ScrollListener scrollListener = new ScrollListener();
            this.graphScroller.getHorizontalScrollBar().addAdjustmentListener(scrollListener);
            this.graphScroller.getVerticalScrollBar().addAdjustmentListener(scrollListener);
        }
        return this.graphScroller;
    }

    public JToolBar getButtonToolBar() {
        if (this.buttonToolBar == null) {
            this.zoomInButton = ToolBarComponentFactory.createButton(false, false);
            this.zoomInButton.setToolTipText("Zoom in");
            this.initialiseToolBarButton(this.zoomInButton);
            this.zoomInButton.setIcon(VisualConstants.ZOOM_IN_ICON);
            this.zoomOutButton = ToolBarComponentFactory.createButton(false, false);
            this.zoomOutButton.setToolTipText("Zoom out");
            this.initialiseToolBarButton(this.zoomOutButton);
            this.zoomOutButton.setIcon(VisualConstants.ZOOM_OUT_ICON);
            this.autoZoomChecBbox = ToolBarComponentFactory.createCheckBox("Fit");
            this.autoZoomChecBbox.setToolTipText("Scale workflow to show all datasets");
            this.autoZoomChecBbox.setSelected(true);
            this.initialiseToolBarButton(this.autoZoomChecBbox);
            this.historyButton = ToolBarComponentFactory.createButton(true, false);
            this.historyButton.setToolTipText("Show analyse history for the selected dataset");
            this.initialiseToolBarButton(this.historyButton);
            this.historyButton.setIcon(VisualConstants.GENERATE_HISTORY_ICON);
            this.historyButton.setEnabled(false);
            this.buttonToolBar = new JToolBar();
            this.buttonToolBar.setFloatable(false);
            this.buttonToolBar.setMinimumSize(new Dimension(0, 0));
            this.buttonToolBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
            this.buttonToolBar.add(this.zoomInButton);
            this.buttonToolBar.add(this.zoomOutButton);
            this.buttonToolBar.add(this.autoZoomChecBbox);
            this.buttonToolBar.add(Box.createHorizontalGlue());
            this.buttonToolBar.add(this.historyButton);
        }
        return this.buttonToolBar;
    }

    private void initialiseToolBarButton(AbstractButton button) {
        button.addActionListener(this);
        button.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
    }

    public void pointToCenter(Point2D target) {
        Point newViewPos = new Point();
        newViewPos.x = (int)(target.getX() - (double)this.graphScroller.getViewport().getWidth() / 2.0);
        newViewPos.y = (int)(target.getY() - (double)this.graphScroller.getViewport().getHeight() / 2.0);
        this.setViewPosition(newViewPos);
    }

    public void setViewPosition(Point p) {
        Point2D p2 = this.graph.toScreen(p);
        JScrollPane scroller = this.getScroller();
        double newX = p2.getX();
        double newY = p2.getY();
        int graphW = this.graph.getWidth();
        int graphH = this.graph.getHeight();
        int viewW = scroller.getViewport().getWidth();
        int viewH = scroller.getViewport().getHeight();
        int xLimit = graphW - viewW;
        int yLimit = graphH - viewH;
        if (newX > (double)xLimit) {
            newX = xLimit;
        }
        if (newY > (double)yLimit) {
            newY = yLimit;
        }
        if (newX < 0.0) {
            newX = 0.0;
        }
        if (newY < 0.0) {
            newY = 0.0;
        }
        scroller.getViewport().setViewPosition(new Point((int)newX, (int)newY));
        this.graph.repaint();
    }

    public JScrollPane getScroller() {
        return this.graphScroller;
    }

    public boolean setGraphScale(double scale) {
        double newScale = scale;
        if (scale > 1.0) {
            newScale = 1.0;
            this.zoomInButton.setEnabled(false);
        } else {
            this.zoomInButton.setEnabled(true);
        }
        if (scale < (double)0.2f) {
            newScale = 0.2f;
            this.zoomOutButton.setEnabled(false);
        } else {
            this.zoomOutButton.setEnabled(true);
        }
        this.graph.setScale(newScale);
        this.graphScroller.repaint();
        return newScale == scale;
    }

    private void showPopupMenu(MouseEvent e) {
        List<AbstractGraphVertex> chosenCells = this.graph.getVertexesAtPoint(e.getPoint());
        if (chosenCells != null && chosenCells.size() > 0) {
            ArrayList<DataItem> items = new ArrayList<DataItem>();
            for (DataBean bean : this.application.getSelectionManager().getSelectedDataBeans()) {
                items.add(bean);
            }
            this.application.showPopupMenuFor(e, items);
        } else {
            DataItem nullBean = null;
            this.application.showPopupMenuFor(e, nullBean);
        }
    }

    private void zoomInToolUsed() {
        double d = this.graph.getScale();
        this.getClass();
        if (this.setGraphScale(d * (double)1.2f)) {
            JViewport view = this.getScroller().getViewport();
            Point viewPos = view.getViewPosition();
            this.center = new Point((int)(viewPos.getX() + (double)(view.getWidth() / 2)), (int)(viewPos.getY() + (double)(view.getHeight() / 2)));
            logger.debug("view.getX: " + view.getX() + ", viewWidth: " + view.getWidth());
            double d2 = this.center.getX();
            this.getClass();
            this.center.x = (int)(d2 * (double)1.2f);
            double d3 = this.center.getY();
            this.getClass();
            this.center.y = (int)(d3 * (double)1.2f);
            Thread centerer = new Thread(){

                public void run() {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    GraphPanel.this.pointToCenter(GraphPanel.this.center);
                }
            };
            this.updateGridSize();
            this.pointToCenter(this.center);
            SwingUtilities.invokeLater(centerer);
        }
        this.graph.repaint();
    }

    private void zoomOutToolUsed() {
        double d = this.graph.getScale();
        this.getClass();
        if (this.setGraphScale(d / (double)1.2f)) {
            JViewport view = this.getScroller().getViewport();
            Point viewPos = view.getViewPosition();
            this.center = new Point((int)(viewPos.getX() + (double)(view.getWidth() / 2)), (int)(viewPos.getY() + (double)(view.getHeight() / 2)));
            double d2 = this.center.getX();
            this.getClass();
            this.center.x = (int)(d2 / (double)1.2f);
            double d3 = this.center.getY();
            this.getClass();
            this.center.y = (int)(d3 / (double)1.2f);
            this.updateGridSize();
            this.pointToCenter(this.center);
        }
        this.repaint();
        this.getScroller().repaint();
        this.graph.repaint();
    }

    private void updateGridSize() {
        double size = 10.0;
        if (this.graph.getScale() <= 0.5) {
            size = 20.0;
        }
        if (this.graph.getScale() <= 0.25) {
            size = 40.0;
        }
        this.graph.setGridSize(size);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e instanceof DatasetChoiceEvent) {
            SwingTools.runInEventDispatchThread(new Runnable(){

                public void run() {
                    if (GraphPanel.this.application.getSelectionManager().getSelectedDataBean() != null) {
                        DataBean bean = GraphPanel.this.application.getSelectionManager().getSelectedDataBean();
                        GraphPanel.this.graph.scrollCellToVisibleAnimated(GraphPanel.this.graph.getVertexMap().get(bean));
                    }
                    GraphPanel.this.graph.repaint();
                    GraphPanel.this.historyButton.setEnabled(GraphPanel.this.application.getSelectionManager().getSelectedItem() instanceof DataBean);
                }
            });
        }
    }

    public void dataChanged(DataChangeEvent event) {
        if (!(event instanceof ContentChangedEvent) && !(event instanceof LinksChangedEvent) && event instanceof DataItemCreatedEvent) {
            SwingTools.runInEventDispatchThread(new Runnable(){

                public void run() {
                    GraphPanel.this.autoZoom();
                }
            });
        }
    }

    public class WorkflowSelectionListener
    implements GraphSelectionListener {
        public void valueChanged(GraphSelectionEvent e) {
            if (!GraphPanel.this.internalSelection) {
                boolean emptySelection = GraphPanel.this.graph.getSelectionCount() == 0;
                GraphPanel.this.application.getSelectionManager().clearAll(emptySelection, GraphPanel.this.graph);
                ArrayList<AbstractGraphVertex> vertexes = new ArrayList<AbstractGraphVertex>();
                for (Object obj : GraphPanel.this.graph.getSelectionCells()) {
                    if (obj instanceof GroupVertex) {
                        GroupVertex group = (GroupVertex)obj;
                        vertexes.addAll(group.getChildVertexes());
                    }
                    if (!(obj instanceof GraphVertex)) continue;
                    vertexes.add((AbstractGraphVertex)obj);
                }
                ArrayList<DataItem> items = new ArrayList<DataItem>();
                for (AbstractGraphVertex vertex : vertexes) {
                    items.add((DataItem)vertex.getUserObject());
                }
                GraphPanel.this.application.getSelectionManager().selectMultiple(items, (Object)GraphPanel.this.graph);
            }
        }
    }

    private class ScrollListener
    implements AdjustmentListener {
        private ScrollListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            GraphPanel.this.getGraph().repaint();
        }
    }
}

