/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.dialog.RenameDialog;
import fi.csc.microarray.client.selection.DataSelectionManager;
import fi.csc.microarray.client.selection.DatasetChoiceEvent;
import fi.csc.microarray.client.visualisation.VisualisationFrameManager;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.client.visualisation.VisualisationToolBar;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.module.chipster.ChipsterInputTypes;
import fi.csc.microarray.util.Files;
import fi.csc.microarray.wizard.WizardPlugin;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class MicroarrayMenuBar
extends JMenuBar
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(MicroarrayMenuBar.class);
    private SwingClientApplication application;
    private JMenu fileMenu = null;
    private JMenu importMenu = null;
    private JMenuItem directImportMenuItem = null;
    private JMenuItem importFromURLMenuItem = null;
    private JMenuItem importFromClipboardMenuItem = null;
    private JMenuItem openWorkflowsMenuItem = null;
    private JMenuItem addDirMenuItem = null;
    private JMenuItem exportMenuItem = null;
    private JMenuItem quitMenuItem = null;
    private JMenu editMenu = null;
    private JMenuItem renameMenuItem = null;
    private JMenuItem deleteMenuItem = null;
    private JMenu viewMenu = null;
    private JMenuItem restoreViewMenuItem = null;
    private JMenu fontSizeMenu = null;
    private JMenu wizardMenu = null;
    private JMenu workflowsMenu = null;
    private JMenuItem wizardMenuItem = null;
    private JMenu helpInfoMenu = null;
    private JMenuItem aboutMenuItem = null;
    private JMenuItem contentMenuItem;
    private JMenuItem startedMenuItem;
    private JMenuItem saveWorkflowMenuItem;
    private JMenuItem saveSnapshotMenuItem;
    private JMenu recentWorkflowMenu;
    private JMenuItem loadSnapshotMenuItem;
    private JMenuItem taskListMenuItem;
    private JMenuItem clearSessionMenuItem;
    private JMenuItem selectAllMenuItem;
    private JMenuItem historyMenuItem;
    private JMenuItem maximiseVisualisationMenuItem;
    private JMenuItem visualiseMenuItem;
    private JMenuItem detachMenuItem;
    private JMenu visualisationMenu;
    private JMenuItem loadOldWorkspaceMenuItem;
    private JMenu openRepoWorkflowsMenu;

    public MicroarrayMenuBar(SwingClientApplication application) {
        this.application = application;
        this.add(this.getFileMenu());
        this.add(this.getEditMenu());
        this.add(this.getViewMenu());
        this.add(this.getWizardMenu());
        this.add(this.getWorkflowsMenu());
        this.add(this.getHelpInfoMenu());
        application.addPropertyChangeListener(this);
    }

    public void updateMenuStatus() {
        logger.debug("updating menubar when selected is " + this.application.getSelectionManager().getSelectedItem());
        DataSelectionManager selectionManager = this.application.getSelectionManager();
        DataBean selectedDataBean = selectionManager.getSelectedDataBean();
        boolean somethingSelected = selectionManager.getSelectedItem() != null;
        boolean normalisedDataSelected = false;
        if (selectedDataBean != null) {
            normalisedDataSelected = ChipsterInputTypes.GENE_EXPRS.isTypeOf(selectedDataBean);
        }
        this.historyMenuItem.setEnabled(selectedDataBean != null && this.application.getSelectionManager().getSelectedDataBeans().size() == 1);
        this.visualiseMenuItem.setEnabled(selectedDataBean != null);
        VisualisationMethod method = this.application.getVisualisationFrameManager().getFrame(VisualisationFrameManager.FrameType.MAIN).getMethod();
        this.visualisationMenu.setEnabled(method != null && method != VisualisationMethod.NONE);
        this.recentWorkflowMenu.setEnabled(normalisedDataSelected);
        this.openWorkflowsMenuItem.setEnabled(normalisedDataSelected);
        this.openRepoWorkflowsMenu.setEnabled(normalisedDataSelected);
        this.saveWorkflowMenuItem.setEnabled(normalisedDataSelected);
        this.exportMenuItem.setEnabled(somethingSelected);
        this.renameMenuItem.setEnabled(somethingSelected);
        this.deleteMenuItem.setEnabled(somethingSelected);
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.setMnemonic('F');
            this.fileMenu.add(this.getDirectImportMenuItem());
            this.fileMenu.add(this.getAddDirMenuItem());
            this.fileMenu.add(this.getImportMenu());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getExportMenuItem());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getLoadSnapshotMenuItem());
            this.fileMenu.add(this.getSaveSnapshotMenuItem());
            this.fileMenu.add(this.getClearSessionMenuItem());
            this.fileMenu.add(this.getLoadOldWorkspaceMenuItem());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getQuitMenuItem());
        }
        return this.fileMenu;
    }

    private JMenu getImportMenu() {
        if (this.importMenu == null) {
            this.importMenu = new JMenu();
            this.importMenu.setText("Import from");
            this.importMenu.add(this.getImportFromURLMenuItem());
            this.importMenu.add(this.getImportFromClipboardMenuItem());
        }
        return this.importMenu;
    }

    private JMenuItem getDirectImportMenuItem() {
        if (this.directImportMenuItem == null) {
            this.directImportMenuItem = new JMenuItem();
            this.directImportMenuItem.setText("Import files...");
            this.directImportMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.directImportMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MicroarrayMenuBar.this.application.openFileImport();
                    }
                    catch (Exception me) {
                        MicroarrayMenuBar.this.application.reportException(me);
                    }
                }
            });
        }
        return this.directImportMenuItem;
    }

    private JMenuItem getImportFromURLMenuItem() {
        if (this.importFromURLMenuItem == null) {
            this.importFromURLMenuItem = new JMenuItem();
            this.importFromURLMenuItem.setText("URL...");
            this.importFromURLMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MicroarrayMenuBar.this.application.openURLImport();
                    }
                    catch (Exception me) {
                        MicroarrayMenuBar.this.application.reportException(me);
                    }
                }
            });
        }
        return this.importFromURLMenuItem;
    }

    private JMenuItem getOpenWorkflowMenuItem() {
        if (this.openWorkflowsMenuItem == null) {
            this.openWorkflowsMenuItem = new JMenuItem();
            this.openWorkflowsMenuItem.setText("Open and run...");
            this.openWorkflowsMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        File workflow = MicroarrayMenuBar.this.application.openWorkflow();
                        MicroarrayMenuBar.this.addRecentWorkflow(workflow.getName(), Files.toUrl(workflow));
                    }
                    catch (Exception me) {
                        MicroarrayMenuBar.this.application.reportException(me);
                    }
                }
            });
        }
        return this.openWorkflowsMenuItem;
    }

    private JMenu getOpenRepositoryWorkflowMenu() {
        if (this.openRepoWorkflowsMenu == null) {
            String[][] flows = new String[][]{{"Find differentially expressed genes", "/find-differentially-expressed-genes.bsh"}, {"Find genes using classification analysis", "/find-genes-with-classification.bsh"}};
            this.openRepoWorkflowsMenu = new JMenu();
            this.openRepoWorkflowsMenu.setText("Run from repository");
            for (String[] flow : flows) {
                JMenuItem item = new JMenuItem(flow[0]);
                item.addActionListener(new RepoWorkflowActionListener(flow[0], flow[1]));
                this.openRepoWorkflowsMenu.add(item);
            }
        }
        return this.openRepoWorkflowsMenu;
    }

    public void addRecentWorkflow(String name, URL url) {
        if (url != null) {
            for (int i = 0; i < this.recentWorkflowMenu.getItemCount(); ++i) {
                JMenuItem menuItem = this.recentWorkflowMenu.getItem(i);
                if (!menuItem.getText().equals(name)) continue;
                this.recentWorkflowMenu.remove(menuItem);
            }
            this.recentWorkflowMenu.add(this.createRunWorkflowMenuItem(name, url));
        }
    }

    private JMenuItem getImportFromClipboardMenuItem() {
        if (this.importFromClipboardMenuItem == null) {
            this.importFromClipboardMenuItem = new JMenuItem();
            this.importFromClipboardMenuItem.setText("clipboard...");
            this.importFromClipboardMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MicroarrayMenuBar.this.application.openClipboardImport();
                    }
                    catch (Exception me) {
                        MicroarrayMenuBar.this.application.reportException(me);
                    }
                }
            });
        }
        return this.importFromClipboardMenuItem;
    }

    private JMenuItem getExportMenuItem() {
        if (this.exportMenuItem == null) {
            this.exportMenuItem = new JMenuItem();
            this.exportMenuItem.setText("Export dataset(s) or folder...");
            this.exportMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.exportMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.exportSelectedItems();
                }
            });
        }
        return this.exportMenuItem;
    }

    private JMenuItem getQuitMenuItem() {
        if (this.quitMenuItem == null) {
            this.quitMenuItem = new JMenuItem();
            this.quitMenuItem.setText("Quit");
            this.quitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.quitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.quit();
                }
            });
        }
        return this.quitMenuItem;
    }

    private JMenu getEditMenu() {
        if (this.editMenu == null) {
            this.editMenu = new JMenu();
            this.editMenu.setText("Edit");
            this.editMenu.setMnemonic('E');
            this.editMenu.add(this.getRenameMenuItem());
            this.editMenu.add(this.getDeleteMenuItem());
            this.editMenu.add(this.getHistoryMenuItem());
            this.editMenu.addSeparator();
            this.editMenu.add(this.getSelectAllMenuItem());
        }
        return this.editMenu;
    }

    private JMenuItem getHistoryMenuItem() {
        if (this.historyMenuItem == null) {
            this.historyMenuItem = new JMenuItem();
            this.historyMenuItem.setText("Show history...");
            this.historyMenuItem.setIcon(VisualConstants.GENERATE_HISTORY_ICON);
            this.historyMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.historyMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DataBean data = MicroarrayMenuBar.this.application.getSelectionManager().getSelectedDataBean();
                    if (data != null) {
                        MicroarrayMenuBar.this.application.showHistoryScreenFor(data);
                    }
                }
            });
        }
        return this.historyMenuItem;
    }

    private JMenuItem getRenameMenuItem() {
        if (this.renameMenuItem == null) {
            this.renameMenuItem = new JMenuItem();
            this.renameMenuItem.setText("Rename selected item...");
            this.renameMenuItem.setAccelerator(KeyStroke.getKeyStroke(113, 0));
            this.renameMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new RenameDialog(MicroarrayMenuBar.this.application, MicroarrayMenuBar.this.application.getSelectionManager().getSelectedItem());
                }
            });
        }
        return this.renameMenuItem;
    }

    private JMenuItem getDeleteMenuItem() {
        if (this.deleteMenuItem == null) {
            this.deleteMenuItem = new JMenuItem();
            this.deleteMenuItem.setText("Delete selected item");
            this.deleteMenuItem.setIcon(VisualConstants.DELETE_MENUICON);
            this.deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
            this.deleteMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.deleteDatas(MicroarrayMenuBar.this.application.getSelectionManager().getSelectedDataBeans().toArray(new DataItem[0]));
                }
            });
        }
        return this.deleteMenuItem;
    }

    private JMenuItem getSelectAllMenuItem() {
        if (this.selectAllMenuItem == null) {
            this.selectAllMenuItem = new JMenuItem();
            this.selectAllMenuItem.setText("Select all");
            this.selectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.selectAllMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.selectAllItems();
                }
            });
        }
        return this.selectAllMenuItem;
    }

    private JMenu getWizardMenu() {
        if (this.wizardMenu == null) {
            this.wizardMenu = new JMenu();
            this.wizardMenu.setText("Wizard");
            this.wizardMenu.setMnemonic('W');
            this.wizardMenu.add(this.getWizardMenuItem());
        }
        return this.wizardMenu;
    }

    private JMenu getWorkflowsMenu() {
        if (this.workflowsMenu == null) {
            this.workflowsMenu = new JMenu();
            this.workflowsMenu.setText("Workflow");
            this.workflowsMenu.add(this.getOpenWorkflowMenuItem());
            this.workflowsMenu.add(this.getOpenRepositoryWorkflowMenu());
            this.workflowsMenu.add(this.getRecentWorkflowMenu());
            this.workflowsMenu.add(this.getSaveWorkflowMenuItem());
        }
        return this.workflowsMenu;
    }

    private JMenuItem getTaskListMenuItem() {
        if (this.taskListMenuItem == null) {
            this.taskListMenuItem = new JMenuItem();
            this.taskListMenuItem.setText("Tasks...");
            this.taskListMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.taskListMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.flipTaskListVisibility(false);
                }
            });
        }
        return this.taskListMenuItem;
    }

    private JMenuItem getSaveWorkflowMenuItem() {
        if (this.saveWorkflowMenuItem == null) {
            this.saveWorkflowMenuItem = new JMenuItem();
            this.saveWorkflowMenuItem.setText("Save starting from selected...");
            this.saveWorkflowMenuItem.setEnabled(false);
            this.saveWorkflowMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    File workflow = MicroarrayMenuBar.this.application.saveWorkflow();
                    MicroarrayMenuBar.this.addRecentWorkflow(workflow.getName(), Files.toUrl(workflow));
                }
            });
        }
        return this.saveWorkflowMenuItem;
    }

    private JMenu getRecentWorkflowMenu() {
        if (this.recentWorkflowMenu == null) {
            this.recentWorkflowMenu = new JMenu();
            this.recentWorkflowMenu.setText("Run recent");
            List<File> workflows = this.application.getWorkflows();
            for (File workflow : workflows) {
                this.addRecentWorkflow(workflow.getName(), Files.toUrl(workflow));
            }
        }
        return this.recentWorkflowMenu;
    }

    private JMenuItem createRunWorkflowMenuItem(String name, final URL workflowScript) {
        JMenuItem runWorkflowMenuItem = new JMenuItem(name);
        runWorkflowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MicroarrayMenuBar.this.application.runWorkflow(workflowScript);
            }
        });
        return runWorkflowMenuItem;
    }

    private JMenuItem getWizardMenuItem() {
        if (this.wizardMenuItem == null) {
            this.wizardMenuItem = new JMenuItem();
            this.wizardMenuItem.setText("Affymetrix");
            this.wizardMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.wizardMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WizardPlugin wiz = new WizardPlugin(MicroarrayMenuBar.this.application);
                    wiz.show();
                }
            });
        }
        return this.wizardMenuItem;
    }

    private JMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new JMenu();
            this.viewMenu.setText("View");
            this.viewMenu.add(this.getRestoreViewMenuItem());
            this.viewMenu.addSeparator();
            this.viewMenu.add(this.getVisualiseMenutItem());
            this.viewMenu.add(this.getVisualisationwMenu());
            this.viewMenu.addSeparator();
            this.viewMenu.add(this.getFontSize());
            this.viewMenu.addSeparator();
            this.viewMenu.add(this.getTaskListMenuItem());
        }
        return this.viewMenu;
    }

    private JMenu getVisualisationwMenu() {
        if (this.visualisationMenu == null) {
            this.visualisationMenu = new JMenu();
            this.visualisationMenu.setText("Visualisation");
            this.visualisationMenu.add(this.getMaximiseVisualisationMenuItem());
            this.visualisationMenu.add(this.getDetachMenuItem());
        }
        return this.visualisationMenu;
    }

    private JMenuItem getDetachMenuItem() {
        if (this.detachMenuItem == null) {
            this.detachMenuItem = new JMenuItem();
            this.detachMenuItem.setText("Detach");
            this.detachMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.detachMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VisualisationToolBar visToolBar = MicroarrayMenuBar.this.application.getVisualisationFrameManager().getVisualisationToolBar();
                    visToolBar.detach();
                }
            });
        }
        return this.detachMenuItem;
    }

    private JMenuItem getMaximiseVisualisationMenuItem() {
        if (this.maximiseVisualisationMenuItem == null) {
            this.maximiseVisualisationMenuItem = new JMenuItem();
            this.maximiseVisualisationMenuItem.setText("Maximise/Restore");
            this.maximiseVisualisationMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 0));
            this.maximiseVisualisationMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VisualisationToolBar visToolBar = MicroarrayMenuBar.this.application.getVisualisationFrameManager().getVisualisationToolBar();
                    visToolBar.maximiseOrRestoreVisualisation();
                }
            });
        }
        return this.maximiseVisualisationMenuItem;
    }

    private JMenuItem getVisualiseMenutItem() {
        if (this.visualiseMenuItem == null) {
            this.visualiseMenuItem = new JMenuItem();
            this.visualiseMenuItem.setText("Visualise selected");
            this.visualiseMenuItem.setAccelerator(KeyStroke.getKeyStroke(10, 0));
            this.visualiseMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.visualiseWithBestMethod(VisualisationFrameManager.FrameType.MAIN);
                }
            });
        }
        return this.visualiseMenuItem;
    }

    private JMenuItem getRestoreViewMenuItem() {
        if (this.restoreViewMenuItem == null) {
            this.restoreViewMenuItem = new JMenuItem();
            this.restoreViewMenuItem.setText("Restore default");
            this.restoreViewMenuItem.setIcon(VisualConstants.DEFAULT_VIEW_MENUICON);
            this.restoreViewMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.restoreDefaultView();
                }
            });
        }
        return this.restoreViewMenuItem;
    }

    private JMenu getHelpInfoMenu() {
        if (this.helpInfoMenu == null) {
            this.helpInfoMenu = new JMenu();
            this.helpInfoMenu.setText("Help");
            this.helpInfoMenu.setMnemonic('H');
            this.helpInfoMenu.add(this.getStartedMenuItem());
            this.helpInfoMenu.add(this.getContentMenuItem());
            this.helpInfoMenu.add(this.getAboutMenuItem());
        }
        return this.helpInfoMenu;
    }

    private JMenuItem getLoadOldWorkspaceMenuItem() {
        if (this.loadOldWorkspaceMenuItem == null) {
            this.loadOldWorkspaceMenuItem = new JMenuItem();
            this.loadOldWorkspaceMenuItem.setText("Open Chipster 1.1 workspace (session)");
            this.loadOldWorkspaceMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MicroarrayMenuBar.this.application.loadOldSnapshot();
                    }
                    catch (Exception exp) {
                        MicroarrayMenuBar.this.application.reportException(exp);
                    }
                }
            });
        }
        return this.loadOldWorkspaceMenuItem;
    }

    private JMenuItem getContentMenuItem() {
        if (this.contentMenuItem == null) {
            this.contentMenuItem = new JMenuItem();
            this.contentMenuItem.setText("User manual");
            this.contentMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
            this.contentMenuItem.setIcon(VisualConstants.HELP_MENUICON);
            this.contentMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.viewHelp("chipster-manual/index.html");
                }
            });
        }
        return this.contentMenuItem;
    }

    private JMenuItem getStartedMenuItem() {
        if (this.startedMenuItem == null) {
            this.startedMenuItem = new JMenuItem();
            this.startedMenuItem.setText("Getting started");
            this.startedMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.viewHelp("chipster-manual/basic-functionality.html");
                }
            });
        }
        return this.startedMenuItem;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText("About");
            this.aboutMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.viewHelp("chipster-manual/about.html");
                }
            });
        }
        return this.aboutMenuItem;
    }

    private JMenu getFontSize() {
        if (this.fontSizeMenu == null) {
            this.fontSizeMenu = new JMenu();
            this.fontSizeMenu.setText("Text size");
            JMenuItem norm = new JMenuItem("Normal");
            JMenuItem inc = new JMenuItem("Increase");
            JMenuItem dec = new JMenuItem("Decrease");
            inc.setAccelerator(KeyStroke.getKeyStroke(521, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            dec.setAccelerator(KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            norm.setAccelerator(KeyStroke.getKeyStroke(48, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.fontSizeMenu.add(inc);
            this.fontSizeMenu.add(dec);
            this.fontSizeMenu.addSeparator();
            this.fontSizeMenu.add(norm);
            norm.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.setFontSize(11.0f);
                }
            });
            dec.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.setFontSize(MicroarrayMenuBar.this.application.getFontSize() - 1.0f);
                }
            });
            inc.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.setFontSize(MicroarrayMenuBar.this.application.getFontSize() + 1.0f);
                }
            });
        }
        return this.fontSizeMenu;
    }

    private JMenuItem getClearSessionMenuItem() {
        if (this.clearSessionMenuItem == null) {
            this.clearSessionMenuItem = new JMenuItem();
            this.clearSessionMenuItem.setText("New session");
            this.clearSessionMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.clearSession();
                }
            });
        }
        return this.clearSessionMenuItem;
    }

    private JMenuItem getLoadSnapshotMenuItem() {
        if (this.loadSnapshotMenuItem == null) {
            this.loadSnapshotMenuItem = new JMenuItem();
            this.loadSnapshotMenuItem.setText("Open session...");
            this.loadSnapshotMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.loadSnapshotMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MicroarrayMenuBar.this.application.loadSession();
                    }
                    catch (Exception ioe) {
                        MicroarrayMenuBar.this.application.reportException(ioe);
                    }
                }
            });
        }
        return this.loadSnapshotMenuItem;
    }

    private JMenuItem getSaveSnapshotMenuItem() {
        if (this.saveSnapshotMenuItem == null) {
            this.saveSnapshotMenuItem = new JMenuItem();
            this.saveSnapshotMenuItem.setText("Save session...");
            this.saveSnapshotMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.saveSnapshotMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.saveSession();
                }
            });
        }
        return this.saveSnapshotMenuItem;
    }

    private JMenuItem getAddDirMenuItem() {
        if (this.addDirMenuItem == null) {
            this.addDirMenuItem = new JMenuItem();
            this.addDirMenuItem.setText("Import folder...");
            this.addDirMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40, false));
            this.addDirMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.openDirectoryImportDialog();
                }
            });
        }
        return this.addDirMenuItem;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt instanceof DatasetChoiceEvent || evt instanceof VisualisationMethodChangedEvent) {
            this.updateMenuStatus();
        }
    }

    private class RepoWorkflowActionListener
    implements ActionListener {
        private String resourceName;
        private String name;

        public RepoWorkflowActionListener(String name, String resourceName) {
            this.name = name;
            this.resourceName = resourceName;
        }

        public void actionPerformed(ActionEvent e) {
            URL url = this.getClass().getResource(this.resourceName);
            MicroarrayMenuBar.this.application.runWorkflow(url);
            MicroarrayMenuBar.this.addRecentWorkflow(this.name, url);
        }
    }
}

