/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.bsh;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.analyser.AnalysisDescription;
import fi.csc.microarray.analyser.AnalysisDescriptionGenerator;
import fi.csc.microarray.analyser.AnalysisException;
import fi.csc.microarray.analyser.AnalysisHandler;
import fi.csc.microarray.analyser.AnalysisJob;
import fi.csc.microarray.analyser.ResultCallback;
import fi.csc.microarray.analyser.VVSADLTool;
import fi.csc.microarray.analyser.bsh.BeanShellJob;
import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.description.VVSADLParser;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.module.chipster.ChipsterVVSADLParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanShellHandler
implements AnalysisHandler {
    private static final String FILETYPE = ".bsh";
    static final Logger logger = Logger.getLogger(BeanShellHandler.class);
    private final String toolPath;
    private final String customScriptsDirName;

    public BeanShellHandler(HashMap<String, String> parameters) throws IOException, ConfigurationLoader.IllegalConfigurationException {
        this.toolPath = parameters.get("toolPath");
        Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
        this.customScriptsDirName = configuration.getString("comp", "custom-scripts-dir");
    }

    @Override
    public AnalysisJob createAnalysisJob(JobMessage message, AnalysisDescription description, ResultCallback resultHandler) {
        BeanShellJob analysisJob = new BeanShellJob();
        analysisJob.construct(message, description, resultHandler);
        return analysisJob;
    }

    @Override
    public AnalysisDescription handle(String sourceResourceName) throws AnalysisException {
        AnalysisDescription ad;
        VVSADLTool.ParsedRScript parsedScript;
        InputStream scriptSource;
        String scriptPath = this.toolPath + File.separator + sourceResourceName;
        logger.debug("creating description from " + scriptPath);
        File scriptFile = new File(this.customScriptsDirName + File.separator + scriptPath);
        if (scriptFile.exists()) {
            FileInputStream customScriptSource;
            try {
                customScriptSource = new FileInputStream(scriptFile);
            }
            catch (FileNotFoundException fnfe) {
                logger.error("Could not load custom script: " + scriptFile, fnfe);
                throw new AnalysisException("Could not load custom script: " + scriptFile);
            }
            scriptSource = customScriptSource;
            logger.info("using custom-script for " + scriptPath);
        } else {
            scriptSource = this.getClass().getResourceAsStream(scriptPath);
        }
        if (scriptSource == null) {
            throw new AnalysisException("Script source " + sourceResourceName + " not found.");
        }
        try {
            parsedScript = new VVSADLTool().parseRScript(scriptSource, "//");
        }
        catch (MicroarrayException e) {
            throw new AnalysisException(e);
        }
        try {
            ad = new AnalysisDescriptionGenerator().generate(new ChipsterVVSADLParser().parse(parsedScript.VVSADL), this);
        }
        catch (VVSADLParser.ParseException e) {
            throw new AnalysisException(e);
        }
        ad.setVVSADL(parsedScript.VVSADL);
        ad.setCommand("BeanShell");
        ad.setImplementation(parsedScript.rSource);
        ad.setSourceCode(parsedScript.rSource);
        ad.setSourceResourceName(sourceResourceName);
        ad.setSourceResourceFullPath(scriptPath);
        return ad;
    }

    @Override
    public boolean supports(String sourceResourceName) {
        logger.debug("do we support " + sourceResourceName + ": " + sourceResourceName.toLowerCase().endsWith(FILETYPE));
        return sourceResourceName.toLowerCase().endsWith(FILETYPE);
    }

    @Override
    public boolean isUptodate(AnalysisDescription description) {
        File scriptFile = new File(this.customScriptsDirName + description.getSourceResourceFullPath());
        return !(scriptFile.exists() ? scriptFile.lastModified() > description.getCreationTime() : description.isUpdatedSinceStartup());
    }

    @Override
    public boolean isDisabled() {
        return false;
    }
}

