/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.usecases.TwoBrokerTopicSendReceiveTest;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class TwoBrokerTopicSendReceiveUsingTcpTest
extends TwoBrokerTopicSendReceiveTest {
    private BrokerService receiverBroker;
    private BrokerService senderBroker;

    protected void setUp() throws Exception {
        BrokerFactoryBean brokerFactory = new BrokerFactoryBean((Resource)new ClassPathResource("org/apache/activemq/usecases/receiver.xml"));
        brokerFactory.afterPropertiesSet();
        this.receiverBroker = brokerFactory.getBroker();
        brokerFactory = new BrokerFactoryBean((Resource)new ClassPathResource("org/apache/activemq/usecases/sender.xml"));
        brokerFactory.afterPropertiesSet();
        this.senderBroker = brokerFactory.getBroker();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.receiverBroker != null) {
            this.receiverBroker.stop();
        }
        if (this.senderBroker != null) {
            this.senderBroker.stop();
        }
    }

    protected ActiveMQConnectionFactory createReceiverConnectionFactory() throws JMSException {
        try {
            ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory(((TransportConnector)this.receiverBroker.getTransportConnectors().get(0)).getConnectUri());
            return fac;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected ActiveMQConnectionFactory createSenderConnectionFactory() throws JMSException {
        try {
            ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory(((TransportConnector)this.senderBroker.getTransportConnectors().get(0)).getConnectUri());
            return fac;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

