/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.network.NetworkTestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FailoverConsumerTest
extends NetworkTestSupport {
    public static final int MSG_COUNT = 100;
    private static final Log LOG = LogFactory.getLog(FailoverConsumerTest.class);

    public void testPublisherFailsOver() throws Exception {
        URI failoverURI = new URI("failover://tcp://localhost:61616");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(failoverURI);
        ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
        prefetchPolicy.setQueuePrefetch(90);
        factory.setPrefetchPolicy(prefetchPolicy);
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)new ActiveMQQueue("Test"));
        for (int idx = 0; idx < 100; ++idx) {
            producer.send((Message)session.createTextMessage("Test"));
        }
        producer.close();
        session.close();
        int count = 0;
        Session consumerSession = connection.createSession(false, 2);
        MessageConsumer consumer = consumerSession.createConsumer((Destination)new ActiveMQQueue("Test"));
        connection.start();
        Message msg = consumer.receive(3000L);
        LOG.info((Object)"You should restart remote broker now and press enter!");
        System.in.read();
        this.restartRemoteBroker();
        msg.acknowledge();
        ++count;
        for (int idx = 1; idx < 100; ++idx) {
            msg = consumer.receive(3000L);
            if (msg == null) {
                LOG.error((Object)("No messages received! Received:" + count));
                break;
            }
            msg.acknowledge();
            ++count;
        }
        FailoverConsumerTest.assertEquals((int)count, (int)100);
        consumer.close();
        consumerSession.close();
        connection.close();
        connection = factory.createConnection();
        consumerSession = connection.createSession(false, 2);
        consumer = consumerSession.createConsumer((Destination)new ActiveMQQueue("Test"));
        connection.start();
        count = 0;
        do {
            if ((msg = consumer.receive(1000L)) == null) continue;
            msg.acknowledge();
            ++count;
        } while (msg != null);
        FailoverConsumerTest.assertEquals((int)count, (int)0);
        consumer.close();
        consumerSession.close();
        connection.close();
    }

    protected String getRemoteURI() {
        return "tcp://localhost:55555";
    }
}

