/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.filter.DestinationMap;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.security.AuthorizationMap;
import org.apache.activemq.security.AuthorizationPlugin;
import org.apache.activemq.security.JaasAuthenticationPlugin;
import org.apache.activemq.security.SecurityTestSupport;
import org.apache.activemq.security.SimpleAuthenticationBroker;
import org.apache.activemq.security.SimpleAuthorizationMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleSecurityBrokerSystemTest
extends SecurityTestSupport {
    static final GroupPrincipal GUESTS;
    static final GroupPrincipal USERS;
    static final GroupPrincipal ADMINS;
    private static final Log LOG;
    public BrokerPlugin authorizationPlugin;
    public BrokerPlugin authenticationPlugin;

    public static Test suite() {
        return SimpleSecurityBrokerSystemTest.suite(SimpleSecurityBrokerSystemTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SimpleSecurityBrokerSystemTest.suite());
    }

    public static AuthorizationMap createAuthorizationMap() {
        DestinationMap readAccess = new DestinationMap();
        readAccess.put((ActiveMQDestination)new ActiveMQQueue(">"), (Object)ADMINS);
        readAccess.put((ActiveMQDestination)new ActiveMQQueue("USERS.>"), (Object)USERS);
        readAccess.put((ActiveMQDestination)new ActiveMQQueue("GUEST.>"), (Object)GUESTS);
        readAccess.put((ActiveMQDestination)new ActiveMQTopic(">"), (Object)ADMINS);
        readAccess.put((ActiveMQDestination)new ActiveMQTopic("USERS.>"), (Object)USERS);
        readAccess.put((ActiveMQDestination)new ActiveMQTopic("GUEST.>"), (Object)GUESTS);
        DestinationMap writeAccess = new DestinationMap();
        writeAccess.put((ActiveMQDestination)new ActiveMQQueue(">"), (Object)ADMINS);
        writeAccess.put((ActiveMQDestination)new ActiveMQQueue("USERS.>"), (Object)USERS);
        writeAccess.put((ActiveMQDestination)new ActiveMQQueue("GUEST.>"), (Object)USERS);
        writeAccess.put((ActiveMQDestination)new ActiveMQQueue("GUEST.>"), (Object)GUESTS);
        writeAccess.put((ActiveMQDestination)new ActiveMQTopic(">"), (Object)ADMINS);
        writeAccess.put((ActiveMQDestination)new ActiveMQTopic("USERS.>"), (Object)USERS);
        writeAccess.put((ActiveMQDestination)new ActiveMQTopic("GUEST.>"), (Object)USERS);
        writeAccess.put((ActiveMQDestination)new ActiveMQTopic("GUEST.>"), (Object)GUESTS);
        readAccess.put((ActiveMQDestination)new ActiveMQTopic("ActiveMQ.Advisory.>"), (Object)GUESTS);
        readAccess.put((ActiveMQDestination)new ActiveMQTopic("ActiveMQ.Advisory.>"), (Object)USERS);
        writeAccess.put((ActiveMQDestination)new ActiveMQTopic("ActiveMQ.Advisory.>"), (Object)GUESTS);
        writeAccess.put((ActiveMQDestination)new ActiveMQTopic("ActiveMQ.Advisory.>"), (Object)USERS);
        DestinationMap adminAccess = new DestinationMap();
        adminAccess.put((ActiveMQDestination)new ActiveMQTopic(">"), (Object)ADMINS);
        adminAccess.put((ActiveMQDestination)new ActiveMQTopic(">"), (Object)USERS);
        adminAccess.put((ActiveMQDestination)new ActiveMQTopic(">"), (Object)GUESTS);
        adminAccess.put((ActiveMQDestination)new ActiveMQQueue(">"), (Object)ADMINS);
        adminAccess.put((ActiveMQDestination)new ActiveMQQueue(">"), (Object)USERS);
        adminAccess.put((ActiveMQDestination)new ActiveMQQueue(">"), (Object)GUESTS);
        return new SimpleAuthorizationMap(writeAccess, readAccess, adminAccess);
    }

    public void initCombos() {
        this.addCombinationValues("authorizationPlugin", new Object[]{new AuthorizationPlugin(SimpleSecurityBrokerSystemTest.createAuthorizationMap())});
        this.addCombinationValues("authenticationPlugin", new Object[]{new SimpleAuthenticationFactory(), new JaasAuthenticationPlugin()});
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        broker.setPlugins(new BrokerPlugin[]{this.authorizationPlugin, this.authenticationPlugin});
        broker.setPersistent(false);
        return broker;
    }

    static {
        URL resource;
        GUESTS = new GroupPrincipal("guests");
        USERS = new GroupPrincipal("users");
        ADMINS = new GroupPrincipal("admins");
        LOG = LogFactory.getLog(SimpleSecurityBrokerSystemTest.class);
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = SimpleSecurityBrokerSystemTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
        LOG.info((Object)("Path to login config: " + path));
    }

    static class SimpleAuthenticationFactory
    implements BrokerPlugin {
        SimpleAuthenticationFactory() {
        }

        public Broker installPlugin(Broker broker) {
            HashMap<String, String> u = new HashMap<String, String>();
            u.put("system", "manager");
            u.put("user", "password");
            u.put("guest", "password");
            HashMap<String, HashSet<Object>> groups = new HashMap<String, HashSet<Object>>();
            groups.put("system", new HashSet<Object>(Arrays.asList(ADMINS, USERS)));
            groups.put("user", new HashSet<Object>(Arrays.asList(USERS)));
            groups.put("guest", new HashSet<Object>(Arrays.asList(GUESTS)));
            return new SimpleAuthenticationBroker(broker, u, groups);
        }

        public String toString() {
            return "SimpleAuthenticationBroker";
        }
    }
}

