/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NumberRangesWhileMarshallingTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(NumberRangesWhileMarshallingTest.class);
    protected String connectionId = "Cheese";
    protected ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    protected DataOutputStream ds = new DataOutputStream(this.buffer);
    protected OpenWireFormat openWireformat;
    protected int endOfStreamMarker = 305419896;

    public void testLongNumberRanges() throws Exception {
        long[] numberValues = new long[]{0L, 1L, 126L, 127L, 128L, 129L, 240L, 255L, 32511L, 32767L, 32769L, 32768L, 57344L, 917505L, 65280L, 65535L, 65536L, 0x700000L, 305419896L, 1916032632L, Integer.MAX_VALUE, 0x80000000L, 0x80000001L, 0xE0000001L, 0xFFFFFFFFL, 4886718337L, 78187493394L, 1250999894307L, 20015998308916L, 320255972942661L, 5124095567082582L, 35523393051833430L, 0x7FFFFFFFFFFFFFL, 0x80000000000000L, 0x80000000000001L, 0xE0000000000001L, 0xFFFFFFFFFFFFFFL, 1311768465173141112L, Long.MAX_VALUE, Long.MIN_VALUE, -9223372036854775807L, -2305843009213693951L, -1L, 1L};
        for (int i = 0; i < numberValues.length; ++i) {
            long value = numberValues[i];
            SessionId object = new SessionId();
            object.setConnectionId(this.connectionId);
            object.setValue(value);
            this.writeObject(object);
        }
        this.ds.writeInt(this.endOfStreamMarker);
        this.ds.close();
        ByteArrayInputStream in = new ByteArrayInputStream(this.buffer.toByteArray());
        DataInputStream dis = new DataInputStream(in);
        for (int i = 0; i < numberValues.length; ++i) {
            long value = numberValues[i];
            String expected = Long.toHexString(value);
            LOG.info((Object)("Unmarshaling value: " + i + " = " + expected));
            SessionId command = (SessionId)this.openWireformat.unmarshal((DataInput)dis);
            NumberRangesWhileMarshallingTest.assertEquals((String)("connection ID in object: " + i), (String)this.connectionId, (String)command.getConnectionId());
            String actual = Long.toHexString(command.getValue());
            NumberRangesWhileMarshallingTest.assertEquals((String)("value of object: " + i + " was: " + actual), (String)expected, (String)actual);
        }
        int marker = dis.readInt();
        NumberRangesWhileMarshallingTest.assertEquals((String)"Marker int", (String)Integer.toHexString(this.endOfStreamMarker), (String)Integer.toHexString(marker));
        try {
            byte value = dis.readByte();
            NumberRangesWhileMarshallingTest.fail((String)"Should have reached the end of the stream");
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.openWireformat = this.createOpenWireFormat();
    }

    protected OpenWireFormat createOpenWireFormat() {
        OpenWireFormat wf = new OpenWireFormat();
        wf.setCacheEnabled(true);
        wf.setStackTraceEnabled(false);
        wf.setVersion(1);
        return wf;
    }

    private void writeObject(Object object) throws IOException {
        this.openWireformat.marshal(object, (DataOutput)this.ds);
    }
}

