/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component;

import org.apache.activemq.camel.SetHeaderTest;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelTemplate;
import org.apache.camel.component.uface.swing.SwingBrowser;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit38.AbstractJUnit38SpringContextTests;

@ContextConfiguration
public class BrowseQueuesInUFace
extends AbstractJUnit38SpringContextTests {
    private static final transient Log LOG = LogFactory.getLog(SetHeaderTest.class);
    @Autowired
    protected CamelContext camelContext;
    @Autowired
    protected CamelTemplate template;
    protected String[] queueNames = new String[]{"Sample.A", "Sample.B", "Sample.C"};

    public void testBrowseQueues() throws Exception {
        for (int i = 0; i < this.queueNames.length; ++i) {
            String queueName = this.queueNames[i];
            this.sendMessagesToQueue(queueName, i);
        }
        Thread.sleep(2000L);
        SwingBrowser browser = new SwingBrowser((DefaultCamelContext)this.camelContext);
        browser.run();
        Thread.sleep(50000L);
    }

    protected void sendMessagesToQueue(String queueName, int index) {
        String uri = "activemq:" + queueName;
        int count = index * 2 + 2;
        for (int i = 0; i < count; ++i) {
            String body = "Message: " + i;
            this.template.sendBodyAndHeader(uri, (Object)body, "counter", (Object)i);
        }
        System.out.println("Sent " + count + " messages to: " + uri);
    }
}

