/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AutoFailTestSupport
extends TestCase {
    public static final int EXIT_SUCCESS = 0;
    public static final int EXIT_ERROR = 1;
    private static final Log LOG = LogFactory.getLog(AutoFailTestSupport.class);
    private long maxTestTime = 300000L;
    private Thread autoFailThread;
    private boolean verbose = true;
    private boolean useAutoFail;
    private AtomicBoolean isTestSuccess;

    protected void setUp() throws Exception {
        if (this.isAutoFail()) {
            this.startAutoFailThread();
        }
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.stopAutoFailThread();
    }

    public void startAutoFailThread() {
        this.setAutoFail(true);
        this.isTestSuccess = new AtomicBoolean(false);
        this.autoFailThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Thread.sleep(AutoFailTestSupport.this.getMaxTestTime());
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    if (!AutoFailTestSupport.this.isTestSuccess.get()) {
                        LOG.error((Object)("Test case has exceeded the maximum allotted time to run of: " + AutoFailTestSupport.this.getMaxTestTime() + " ms."));
                        LOG.fatal((Object)("Test case has exceeded the maximum allotted time to run of: " + AutoFailTestSupport.this.getMaxTestTime() + " ms."));
                        System.exit(1);
                    }
                }
            }
        }, "AutoFailThread");
        if (this.verbose) {
            LOG.info((Object)"Starting auto fail thread...");
        }
        LOG.info((Object)"Starting auto fail thread...");
        this.autoFailThread.start();
    }

    public void stopAutoFailThread() {
        if (this.isAutoFail() && this.autoFailThread != null && this.autoFailThread.isAlive()) {
            this.isTestSuccess.set(true);
            if (this.verbose) {
                LOG.info((Object)"Stopping auto fail thread...");
            }
            LOG.info((Object)"Stopping auto fail thread...");
            this.autoFailThread.interrupt();
        }
    }

    public void setAutoFail(boolean val) {
        this.useAutoFail = val;
    }

    public boolean isAutoFail() {
        return this.useAutoFail;
    }

    public void setMaxTestTime(long val) {
        this.maxTestTime = val;
    }

    public long getMaxTestTime() {
        return this.maxTestTime;
    }
}

