/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.handler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.model.dataformat.ArtixDSDataFormat;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.model.dataformat.SerializationDataFormat;
import org.apache.camel.model.dataformat.XMLBeansDataFormat;
import org.apache.camel.model.loadbalancer.RandomLoadBalanceStrategy;
import org.apache.camel.model.loadbalancer.RoundRobinLoadBalanceStrategy;
import org.apache.camel.model.loadbalancer.StickyLoadBalanceStrategy;
import org.apache.camel.model.loadbalancer.TopicLoadBalanceStrategy;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.CamelContextFactoryBean;
import org.apache.camel.spring.CamelTemplateFactoryBean;
import org.apache.camel.spring.EndpointFactoryBean;
import org.apache.camel.spring.handler.BeanDefinitionParser;
import org.apache.camel.spring.handler.ScriptDefinitionParser;
import org.apache.camel.spring.remoting.CamelProxyFactoryBean;
import org.apache.camel.spring.remoting.CamelServiceExporter;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelNamespaceHandler
extends NamespaceHandlerSupport {
    public static final String JAXB_PACKAGES = "org.apache.camel.spring:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer";
    protected BeanDefinitionParser endpointParser = new BeanDefinitionParser(EndpointFactoryBean.class);
    protected BeanDefinitionParser beanPostProcessorParser = new BeanDefinitionParser(CamelBeanPostProcessor.class);
    protected Set<String> parserElementNames = new HashSet<String>();
    private JAXBContext jaxbContext;
    private Map<String, BeanDefinitionParser> parserMap = new HashMap<String, BeanDefinitionParser>();
    private Binder<Node> binder;

    public void init() {
        this.addBeanDefinitionParser("proxy", CamelProxyFactoryBean.class);
        this.addBeanDefinitionParser("template", CamelTemplateFactoryBean.class);
        this.addBeanDefinitionParser("export", CamelServiceExporter.class);
        this.addBeanDefinitionParser("artixDS", ArtixDSDataFormat.class);
        this.addBeanDefinitionParser("jaxb", JaxbDataFormat.class);
        this.addBeanDefinitionParser("serialization", SerializationDataFormat.class);
        this.addBeanDefinitionParser("xmlBeans", XMLBeansDataFormat.class);
        this.addBeanDefinitionParser("roundRobin", RoundRobinLoadBalanceStrategy.class);
        this.addBeanDefinitionParser("random", RandomLoadBalanceStrategy.class);
        this.addBeanDefinitionParser("sticky", StickyLoadBalanceStrategy.class);
        this.addBeanDefinitionParser("topic", TopicLoadBalanceStrategy.class);
        this.registerParser("endpoint", (org.springframework.beans.factory.xml.BeanDefinitionParser)this.endpointParser);
        this.registerParser("camelContext", (org.springframework.beans.factory.xml.BeanDefinitionParser)new CamelContextBeanDefinitionParser(CamelContextFactoryBean.class));
    }

    private void addBeanDefinitionParser(String elementName, Class<?> type) {
        BeanDefinitionParser parser = new BeanDefinitionParser(type);
        this.registerParser(elementName, (org.springframework.beans.factory.xml.BeanDefinitionParser)parser);
        this.parserMap.put(elementName, parser);
    }

    protected void createBeanPostProcessor(ParserContext parserContext, String contextId, Element childElement) {
        String beanPostProcessorId = contextId + ":beanPostProcessor";
        childElement.setAttribute("id", beanPostProcessorId);
        BeanDefinition definition = this.beanPostProcessorParser.parse(childElement, parserContext);
        definition.getPropertyValues().addPropertyValue("camelContext", (Object)new RuntimeBeanReference(contextId));
    }

    protected void registerScriptParser(String elementName, String engineName) {
        this.registerParser(elementName, (org.springframework.beans.factory.xml.BeanDefinitionParser)new ScriptDefinitionParser(engineName));
    }

    protected void registerParser(String name, org.springframework.beans.factory.xml.BeanDefinitionParser parser) {
        this.parserElementNames.add(name);
        this.registerBeanDefinitionParser(name, parser);
    }

    public Set<String> getParserElementNames() {
        return this.parserElementNames;
    }

    protected Object parseUsingJaxb(Element element, ParserContext parserContext) {
        try {
            this.binder = this.getJaxbContext().createBinder();
            return this.binder.unmarshal((Object)element);
        }
        catch (JAXBException e) {
            throw new BeanDefinitionStoreException("Failed to parse JAXB element: " + (Object)((Object)e), (Throwable)e);
        }
    }

    protected JAXBContext getJaxbContext() throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = this.createJaxbContext();
        }
        return this.jaxbContext;
    }

    protected JAXBContext createJaxbContext() throws JAXBException {
        return JAXBContext.newInstance((String)JAXB_PACKAGES);
    }

    protected void injectNamespaces(Element element) {
        NodeList list = element.getChildNodes();
        Namespaces namespaces = null;
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node child = list.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            Object object = this.binder.getJAXBNode((Object)child);
            if (object instanceof NamespaceAware) {
                NamespaceAware namespaceAware = (NamespaceAware)object;
                if (namespaces == null) {
                    namespaces = new Namespaces(element);
                }
                namespaces.configure(namespaceAware);
            }
            this.injectNamespaces(childElement);
        }
    }

    protected class CamelContextBeanDefinitionParser
    extends BeanDefinitionParser {
        public CamelContextBeanDefinitionParser(Class type) {
            super(type);
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            Object value;
            super.doParse(element, parserContext, builder);
            String contextId = element.getAttribute("id");
            if (ObjectHelper.isNullOrBlank((String)contextId)) {
                contextId = "camelContext";
                element.setAttribute("id", contextId);
            }
            if ((value = CamelNamespaceHandler.this.parseUsingJaxb(element, parserContext)) instanceof CamelContextFactoryBean) {
                CamelContextFactoryBean factoryBean = (CamelContextFactoryBean)((Object)value);
                builder.addPropertyValue("id", (Object)contextId);
                builder.addPropertyValue("routes", factoryBean.getRoutes());
                builder.addPropertyValue("builderRefs", factoryBean.getBuilderRefs());
                if (factoryBean.getPackages().length > 0) {
                    builder.addPropertyValue("packages", (Object)factoryBean.getPackages());
                }
            }
            boolean createdBeanPostProcessor = false;
            NodeList list = element.getChildNodes();
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                Node child = list.item(i);
                if (!(child instanceof Element)) continue;
                Element childElement = (Element)child;
                String localName = child.getLocalName();
                if (localName.equals("beanPostProcessor")) {
                    CamelNamespaceHandler.this.createBeanPostProcessor(parserContext, contextId, childElement);
                    createdBeanPostProcessor = true;
                    continue;
                }
                if (localName.equals("endpoint")) {
                    BeanDefinition definition = CamelNamespaceHandler.this.endpointParser.parse(childElement, parserContext);
                    String id = childElement.getAttribute("id");
                    if (!ObjectHelper.isNotNullAndNonEmpty((String)id)) continue;
                    definition.getPropertyValues().addPropertyValue("camelContext", (Object)new RuntimeBeanReference(contextId));
                    parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition(definition, id));
                    continue;
                }
                BeanDefinitionParser parser = (BeanDefinitionParser)((Object)CamelNamespaceHandler.this.parserMap.get(localName));
                if (parser == null) continue;
                BeanDefinition definition = parser.parse(childElement, parserContext);
                String id = childElement.getAttribute("id");
                if (!ObjectHelper.isNotNullAndNonEmpty((String)id)) continue;
                parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition(definition, id));
            }
            CamelNamespaceHandler.this.injectNamespaces(element);
            if (!createdBeanPostProcessor) {
                Element childElement = element.getOwnerDocument().createElement("beanPostProcessor");
                element.appendChild(childElement);
                CamelNamespaceHandler.this.createBeanPostProcessor(parserContext, contextId, childElement);
            }
        }
    }
}

