/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util.rest;

import fi.csc.microarray.filebroker.AuthorisedUrlRepository;
import fi.csc.microarray.util.rest.WelcomePage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.log.Log;
import org.mortbay.util.IO;
import org.mortbay.util.URIUtil;

public class RestServlet
extends DefaultServlet {
    private AuthorisedUrlRepository urlRepository;
    private String rootUrl;

    public RestServlet(AuthorisedUrlRepository urlRepository, String rootUrl) {
        this.urlRepository = urlRepository;
        this.rootUrl = rootUrl;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isValidFilename(request)) {
            response.sendError(404);
        } else {
            super.service(request, response);
        }
    }

    private boolean isValidFilename(HttpServletRequest request) {
        File file = this.locateFile(request);
        if (file.isDirectory()) {
            return false;
        }
        return this.isWelcomePage(request) || this.urlRepository.checkFilenameSyntax(this.constructFilename(request));
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (Log.isDebugEnabled()) {
            Log.debug((String)("RESTful file access: GET request for " + request.getRequestURI()));
        }
        if (this.isWelcomePage(request)) {
            new WelcomePage(this.rootUrl).print(response);
        } else {
            super.doGet(request, response);
        }
    }

    private boolean isWelcomePage(HttpServletRequest request) {
        return "/".equals(this.constructFilename(request));
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean success;
        if (Log.isDebugEnabled()) {
            Log.debug((String)("RESTful file access: PUT request for " + request.getRequestURI()));
        }
        if (!this.urlRepository.isAuthorised(this.constructUrl(request))) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("PUT denied for " + this.constructUrl(request)));
            }
            response.sendError(403);
            return;
        }
        File file = this.locateFile(request);
        if (file.exists() && !(success = file.delete())) {
            response.sendError(500);
            return;
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            IO.copy((InputStream)request.getInputStream(), (OutputStream)out);
        }
        catch (IOException e) {
            Log.warn((String)"EXCEPTION ", (Throwable)e);
            out.close();
            throw e;
        }
        response.setStatus(204);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        File file;
        if (Log.isDebugEnabled()) {
            Log.debug((String)("RESTful file access: DELETE request for " + request.getRequestURI()));
        }
        if (!(file = this.locateFile(request)).exists()) {
            response.sendError(404);
            return;
        }
        boolean success = IO.delete((File)file);
        if (success) {
            response.setStatus(204);
        } else {
            response.sendError(500);
        }
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(405);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(405);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(405);
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(405);
    }

    private File locateFile(HttpServletRequest request) {
        return new File(this.getServletContext().getRealPath(URIUtil.addPaths((String)request.getServletPath(), (String)request.getPathInfo())));
    }

    private String constructFilename(HttpServletRequest request) {
        return request.getPathInfo();
    }

    private URL constructUrl(HttpServletRequest request) throws MalformedURLException {
        return new URL(this.rootUrl + request.getPathInfo());
    }
}

