/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.proto.repository;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.proto.repository.Experiment;
import fi.csc.microarray.proto.repository.Query;
import fi.csc.microarray.proto.repository.schema.ParameterClass;
import java.util.LinkedList;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Repository {
    private static final String REPOSITORY_PROPERTY_PREFIX = "nami.repository.available.";

    public static Iterable<Repository> getAvailableRepositories() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        LinkedList<Repository> repositories = new LinkedList<Repository>();
        Properties properties = System.getProperties();
        for (Object name : properties.keySet()) {
            if (!(name instanceof String) || !((String)name).startsWith(REPOSITORY_PROPERTY_PREFIX)) continue;
            String className = (String)properties.get(name);
            Repository repository = (Repository)Class.forName(className).newInstance();
            repositories.add(repository);
        }
        return repositories;
    }

    public abstract boolean requiresAuthentication();

    public abstract boolean authenticate(String var1, String var2);

    public abstract String getType();

    public abstract String getIdentifier();

    public abstract ParameterClass getRootClass() throws MicroarrayException;

    public abstract int getClassHierarchyDepth();

    public abstract Iterable<Experiment> executeQuery(Query var1) throws MicroarrayException;

    public abstract String toString();
}

