/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.message;

import java.util.UUID;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import org.apache.log4j.Logger;

public abstract class NamiMessage {
    private static final Logger logger = Logger.getLogger(NamiMessage.class);
    public static final String KEY_MESSAGE_ID = "message-id";
    public static final String KEY_CLASS = "class";
    public static final String KEY_USERNAME = "username";
    public static final String KEY_SESSION_ID = "session-id";
    public static final String KEY_MULTIPLEX_CHANNEL = "multiplex-channel";
    private String messageID = UUID.randomUUID().toString();
    private Destination replyTo = null;
    private String username;
    private String sessionID;
    private String multiplexChannel;
    private String jmsMessageID;

    public void unmarshal(MapMessage from) throws JMSException {
        this.messageID = from.getStringProperty(KEY_MESSAGE_ID);
        this.replyTo = from.getJMSReplyTo();
        this.username = from.getStringProperty(KEY_USERNAME);
        this.multiplexChannel = from.getStringProperty(KEY_MULTIPLEX_CHANNEL);
        this.sessionID = from.getStringProperty(KEY_SESSION_ID);
        this.jmsMessageID = from.getJMSMessageID();
    }

    public void marshal(MapMessage to) throws JMSException {
        to.setStringProperty(KEY_MESSAGE_ID, this.messageID);
        to.setStringProperty(KEY_CLASS, this.getClass().getCanonicalName());
        to.setStringProperty(KEY_USERNAME, this.username);
        to.setJMSReplyTo(this.replyTo);
        to.setStringProperty(KEY_MULTIPLEX_CHANNEL, this.multiplexChannel);
        to.setStringProperty(KEY_SESSION_ID, this.sessionID);
    }

    public String getMessageID() {
        return this.messageID;
    }

    public Destination getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(Destination replyTo) {
        this.replyTo = replyTo;
    }

    public String toString() {
        return "MESSAGE message-id: " + this.messageID + ", class: " + this.getClass().getSimpleName();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public String getMultiplexChannel() {
        return this.multiplexChannel;
    }

    public void setMultiplexChannel(String multiplexChannel) {
        this.multiplexChannel = multiplexChannel;
    }

    public String getJmsMessageID() {
        return this.jmsMessageID;
    }

    public void handleException(Exception e) throws JMSException {
        logger.error((Object)e);
        throw new JMSException(e.getMessage());
    }
}

