/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.auth;

import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.auth.AuthenticationRequestListener;
import fi.csc.microarray.messaging.message.AuthenticationMessage;
import fi.csc.microarray.messaging.message.NamiMessage;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.log4j.Logger;

public class AuthenticatedTopic
extends MessagingTopic {
    private static final Logger logger = Logger.getLogger(AuthenticatedTopic.class);
    private AuthenticationRequestListener listener;
    private MessagingListener authTopicListener = new MessagingListener(){

        public void onNamiMessage(NamiMessage msg) {
            block6: {
                try {
                    if (msg instanceof AuthenticationMessage) {
                        AuthenticationMessage authMsg = (AuthenticationMessage)msg;
                        if (authMsg.isRequestForAuthentication()) {
                            logger.debug((Object)("got request for authentication related to topic " + AuthenticatedTopic.this.getName()));
                            AuthenticatedTopic.this.getEndpoint().setSessionID(msg.getSessionID());
                            if (AuthenticatedTopic.this.listener != null) {
                                AuthenticationRequestListener.Credentials credentials = AuthenticatedTopic.this.listener.authenticationRequest();
                                logger.debug((Object)("got authentication request, will send a reply, using session " + msg.getSessionID()));
                                AuthenticationMessage replyMsg = new AuthenticationMessage(AuthenticationMessage.AuthenticationOperation.LOGIN);
                                replyMsg.setUsername(credentials.username);
                                replyMsg.setPassword(credentials.password);
                                replyMsg.setSessionID(msg.getSessionID());
                                replyMsg.setReplyTo(authMsg.getReplyTo());
                                AuthenticatedTopic.this.sendMessage(replyMsg);
                            }
                            break block6;
                        }
                        if (authMsg.isLoginAck()) {
                            AuthenticatedTopic.this.listener.authenticationSucceeded();
                            break block6;
                        }
                        throw new RuntimeException("unknown authentication operation type: " + authMsg.getCommand());
                    }
                    throw new RuntimeException("illegal message type received: " + msg.getClass().getSimpleName());
                }
                catch (JMSException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    };

    public AuthenticatedTopic(Session session, String topicName, MessagingTopic.Type type, MessagingTopic.AccessMode accessMode, AuthenticationRequestListener listener, MessagingEndpoint endpoint) throws JMSException {
        super(session, topicName, type, accessMode, endpoint);
        this.listener = listener;
    }

    public void sendMessage(NamiMessage message) throws JMSException {
        this.attachSessionID(message);
        super.sendMessage(message);
    }

    public void sendReplyableMessage(NamiMessage message, MessagingListener replyListener) throws JMSException {
        this.attachSessionID(message);
        logger.debug((Object)"added authentication listener to message");
        super.sendReplyableMessage(message, replyListener, this.authTopicListener);
    }

    private void attachSessionID(NamiMessage msg) {
        String sessionID = this.getEndpoint().getSessionID();
        if (sessionID != null) {
            msg.setSessionID(sessionID);
        }
    }
}

