/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.messaging.MessageListenerWrapper;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MultiplexingMessagingListener;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.NamiMessage;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.log4j.Logger;

public class MessagingTopic {
    private static final Logger logger = Logger.getLogger(MessagingTopic.class);
    private MessageConsumer consumer;
    private Session session;
    private Topic topic;
    private MessagingEndpoint endpoint;

    public MessagingTopic(Session session, String topicName, Type type, AccessMode accessMode, MessagingEndpoint endpoint) throws JMSException {
        this.session = session;
        switch (type) {
            case NORMAL: {
                this.topic = session.createTopic(topicName);
                break;
            }
            case TEMPORARY: {
                this.topic = session.createTemporaryTopic();
                break;
            }
            default: {
                throw new RuntimeException("unknown type " + (Object)((Object)type));
            }
        }
        if (accessMode == AccessMode.READ || accessMode == AccessMode.READ_WRITE) {
            this.consumer = session.createConsumer((Destination)this.topic);
        }
        this.endpoint = endpoint;
    }

    protected void sendReplyableMessage(NamiMessage message, MessagingListener replyListener, MessagingListener authenticationListener) throws JMSException {
        MessagingTopic tempTopic = new MessagingTopic(this.session, null, Type.TEMPORARY, AccessMode.READ_WRITE, this.endpoint);
        MultiplexingMessagingListener plexer = new MultiplexingMessagingListener();
        plexer.addChannel(Topics.MultiplexName.REPLY_TO.toString(), replyListener);
        if (authenticationListener != null) {
            plexer.addChannel(Topics.MultiplexName.AUTHORISE_TO.toString(), authenticationListener);
        }
        tempTopic.setListener(plexer);
        message.setReplyTo((Destination)tempTopic.topic);
        this.sendMessage(message);
    }

    public void sendReplyableMessage(NamiMessage message, MessagingListener replyListener) throws JMSException {
        this.sendReplyableMessage(message, replyListener, null);
    }

    public void sendMessage(NamiMessage message) throws JMSException {
        logger.debug((Object)("sending " + message));
        MapMessage mapMessage = this.session.createMapMessage();
        message.marshal(mapMessage);
        this.session.createProducer((Destination)this.topic).send((Message)mapMessage);
    }

    public String getName() throws JMSException {
        return this.topic.getTopicName();
    }

    public void setListener(MessagingListener listener) throws JMSException {
        if (this.consumer == null) {
            throw new IllegalStateException("Topic was created as write only");
        }
        this.consumer.setMessageListener((MessageListener)new MessageListenerWrapper(listener));
    }

    public void removeListener() throws JMSException {
        if (this.consumer == null) {
            throw new IllegalStateException("Topic was created as write only");
        }
        this.consumer.setMessageListener(null);
    }

    public OutputStream openJMSOutputStream() throws JMSException {
        return this.endpoint.createOutputStream(this.topic);
    }

    public InputStream openJMSInputStream() throws JMSException {
        return this.endpoint.createInputStream(this.topic);
    }

    public MessagingEndpoint getEndpoint() {
        return this.endpoint;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AccessMode {
        READ,
        WRITE,
        READ_WRITE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NORMAL,
        TEMPORARY,
        NAMED_TEMPORARY;

    }
}

