/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.visualisation.AnnotateListPanel;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.client.visualisation.VisualisationUtilities;
import fi.csc.microarray.client.visualisation.methods.threed.CoordinateArea;
import fi.csc.microarray.client.visualisation.methods.threed.Scatterplot3D;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.LinkUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scatterplot3DPCA
extends Scatterplot3D {
    DataBean phenoBean;

    public Scatterplot3DPCA(VisualisationFrame frame) {
        super(frame);
    }

    @Override
    public AnnotateListPanel createListPanel() {
        return new AnnotateListPanel("Chips");
    }

    @Override
    protected void refreshAxisBoxes(DataBean data) {
        if (this.paramPanel == null) {
            throw new IllegalStateException("must call getParameterPanel first");
        }
        this.updateCombo(this.xBox, data);
        this.updateCombo(this.yBox, data);
        this.updateCombo(this.zBox, data);
        this.phenoBean = LinkUtils.retrieveInherited(data, DataBean.Link.ANNOTATION);
        List<Visualisation.Variable> phenoCols = Arrays.asList(VisualisationUtilities.getVariablesFilteredInclusive(this.phenoBean, "", false));
        ArrayList<Visualisation.Variable> colsToRemove = new ArrayList<Visualisation.Variable>();
        for (Visualisation.Variable col : phenoCols) {
            Iterator<String> values = null;
            try {
                values = this.phenoBean.queryFeatures(col.getExpression()).asStrings().iterator();
                while (values.hasNext()) {
                    try {
                        Float.parseFloat(values.next());
                    }
                    catch (NumberFormatException e) {
                        colsToRemove.add(col);
                    }
                }
            }
            catch (MicroarrayException e1) {
                this.application.reportException(new MicroarrayException("Unable to find phenodata, try normal 3D Scatterplot instead", e1));
            }
        }
        ArrayList<Visualisation.Variable> numericCols = new ArrayList<Visualisation.Variable>();
        for (Visualisation.Variable col : phenoCols) {
            if (colsToRemove.contains(col)) continue;
            numericCols.add(col);
        }
        Visualisation.fillCompoBox(this.colorBox, numericCols.toArray(new Visualisation.Variable[0]));
    }

    @Override
    protected void retrieveData(List<Visualisation.Variable> variables) throws MicroarrayException {
        Iterable<String> identifier = this.data.queryFeatures("/identifier").asStrings();
        Iterable<Float> xValues = this.data.queryFeatures(variables.get(0).getExpression()).asFloats();
        Iterable<Float> yValues = this.data.queryFeatures(variables.get(1).getExpression()).asFloats();
        Iterable<Float> zValues = this.data.queryFeatures(variables.get(2).getExpression()).asFloats();
        Iterable<Float> cValues = this.phenoBean.queryFeatures(variables.get(3).getExpression()).asFloats();
        this.dataModel.setData(identifier, xValues, yValues, zValues, cValues);
    }

    @Override
    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        Object value;
        boolean isTabular = VisualisationMethod.SPREADSHEET.getHeadlessVisualiser().canVisualise(bean);
        boolean isChips = false;
        Parameter pcaOn = bean.getOperation().getParameter("do.pca.on");
        if (pcaOn != null && (value = pcaOn.getValue()) != null && value.equals("chips")) {
            isChips = true;
        }
        return bean.getOperation().getDefinition().getName().equals("PCA") && isChips && isTabular && this.hasRows(bean) && bean.queryFeatures("/column/chip.*").exists();
    }

    @Override
    protected void useButtonPressed() {
        ArrayList<Visualisation.Variable> vars = new ArrayList<Visualisation.Variable>();
        vars.add((Visualisation.Variable)this.xBox.getSelectedItem());
        vars.add((Visualisation.Variable)this.yBox.getSelectedItem());
        vars.add((Visualisation.Variable)this.zBox.getSelectedItem());
        vars.add((Visualisation.Variable)this.colorBox.getSelectedItem());
        this.application.setVisualisationMethod(new VisualisationMethodChangedEvent(this, VisualisationMethod.SCATTERPLOT3DPCA, vars, this.getFrame().getDatas(), this.getFrame().getType(), this.getFrame()));
        this.coordinateArea.setPaintMode(CoordinateArea.PaintMode.PIXEL);
    }
}

