/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dialog;

import fi.csc.microarray.client.Authenticator;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.VisualConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class LoginDialog
extends JDialog
implements ActionListener,
KeyListener {
    private static final String LOGIN_ACTION = "login";
    private static final String CANCEL_ACTION = "cancel";
    private JTextField usernameField;
    private JPasswordField passwordField;
    private Authenticator.LoginCallback loginCallback;
    private boolean previousAttemptFailed = false;

    public static void main(String[] args) {
        LoginDialog dialog = new LoginDialog(null, true);
        dialog.setVisible(true);
    }

    public LoginDialog(Authenticator.LoginCallback callback) {
        this(callback, false);
    }

    public LoginDialog(Authenticator.LoginCallback callback, boolean previousAttemptFailed) {
        this.loginCallback = callback;
        this.previousAttemptFailed = previousAttemptFailed;
        this.setDefaultCloseOperation(0);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.getBanner(), "North");
        this.getContentPane().add(this.getControls(), "Center");
        SwingClientApplication.setPlastic3DLookAndFeel(this);
        this.setLocationRelativeTo(null);
        this.pack();
        this.addKeyListener(this);
    }

    private Component getControls() {
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(40, 40, 10, 10));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.anchor = 17;
        c.insets = new Insets(2, 2, 12, 10);
        c.gridx = 0;
        c.gridy = 0;
        if (this.previousAttemptFailed) {
            c.gridwidth = 2;
            JLabel failedLabel = new JLabel("Login failed, please check your username and password");
            failedLabel.setFont(failedLabel.getFont().deriveFont(2));
            panel.add((Component)failedLabel, c);
            c.gridwidth = 1;
            ++c.gridy;
        }
        c.insets = new Insets(2, 2, 2, 10);
        panel.add((Component)new JLabel("Username"), c);
        c.insets = new Insets(2, 2, 2, 2);
        ++c.gridx;
        this.usernameField = new JTextField(24);
        this.usernameField.addKeyListener(this);
        panel.add((Component)this.usernameField, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(2, 2, 2, 10);
        panel.add((Component)new JLabel("Password"), c);
        c.insets = new Insets(2, 2, 2, 2);
        ++c.gridx;
        this.passwordField = new JPasswordField(24);
        this.passwordField.addKeyListener(this);
        panel.add((Component)this.passwordField, c);
        ++c.gridy;
        c.gridx = 1;
        c.anchor = 13;
        c.insets = new Insets(15, 2, 0, 2);
        JPanel buttonPanel = new JPanel();
        JButton loginButton = new JButton("Login");
        loginButton.setActionCommand(LOGIN_ACTION);
        loginButton.addActionListener(this);
        loginButton.addKeyListener(this);
        buttonPanel.add(loginButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand(CANCEL_ACTION);
        cancelButton.addActionListener(this);
        buttonPanel.add(cancelButton);
        panel.add((Component)buttonPanel, c);
        return panel;
    }

    private Component getBanner() {
        return new JLabel(VisualConstants.LOGIN_BANNER);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == LOGIN_ACTION) {
            this.login();
        } else if (e.getActionCommand() == CANCEL_ACTION) {
            System.exit(1);
        } else {
            throw new RuntimeException("unknown action command: " + e.getActionCommand());
        }
    }

    private void login() {
        this.loginCallback.authenticate(this.usernameField.getText(), new String(this.passwordField.getPassword()));
        this.dispose();
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            this.login();
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }
}

