/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.analyser.AnalysisDescription;
import fi.csc.microarray.analyser.AnalysisException;
import fi.csc.microarray.analyser.AnalysisHandler;
import fi.csc.microarray.analyser.ToolRuntime;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.util.XmlUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ToolRepository {
    private static final Logger logger = Logger.getLogger(ToolRepository.class);
    private LinkedHashMap<String, AnalysisDescription> descriptions = new LinkedHashMap();
    private LinkedHashMap<String, AnalysisDescription> supportedDescriptions = new LinkedHashMap();
    private LinkedHashMap<String, AnalysisDescription> visibleDescriptions = new LinkedHashMap();
    private HashMap<String, ToolRuntime> runtimes = new HashMap();

    public ToolRepository(File workDir) throws Exception {
        this.loadRuntimes(workDir);
        this.loadTools();
    }

    public synchronized AnalysisDescription getDescription(String fullName) throws AnalysisException {
        AnalysisDescription newDescription;
        AnalysisDescription desc = this.descriptions.get(fullName);
        if (desc != null && !desc.isUptodate() && (newDescription = desc.getHandler().handle(desc.getSourceResourceName())) != null) {
            if (desc.getFullName().equals(newDescription.getFullName())) {
                this.descriptions.remove(fullName);
                this.descriptions.put(newDescription.getFullName(), newDescription);
                if (this.supportedDescriptions.containsKey(desc.getFullName())) {
                    this.supportedDescriptions.remove(desc.getFullName());
                    this.supportedDescriptions.put(newDescription.getFullName(), newDescription);
                }
                if (this.visibleDescriptions.containsKey(desc.getFullName())) {
                    this.visibleDescriptions.remove(desc.getFullName());
                    this.visibleDescriptions.put(newDescription.getFullName(), newDescription);
                }
                return newDescription;
            }
            logger.warn((Object)"name of the tool has changed after loading from custom-scripts, keeping both old and new");
            if (this.descriptions.containsKey(newDescription.getFullName())) {
                logger.warn((Object)"descriptions already contains a tool with the new name, ignoring custom-scripts");
                return desc;
            }
            this.descriptions.put(newDescription.getFullName(), newDescription);
            if (this.supportedDescriptions.containsKey(desc.getFullName())) {
                this.supportedDescriptions.put(newDescription.getFullName(), newDescription);
            }
            if (this.visibleDescriptions.containsKey(desc.getFullName())) {
                this.visibleDescriptions.put(newDescription.getFullName(), newDescription);
            }
            return newDescription;
        }
        return desc;
    }

    public synchronized StringBuffer serialiseAsStringBuffer() {
        StringBuffer buf = new StringBuffer();
        for (AnalysisDescription description : this.visibleDescriptions.values()) {
            buf.append(description.getVVSADL());
        }
        return buf;
    }

    public synchronized boolean supports(String fullName) {
        return this.supportedDescriptions.containsKey(fullName);
    }

    private void loadRuntimes(File workDir) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, IOException, SAXException, ParserConfigurationException {
        logger.info((Object)"loading runtimes");
        File runtimeConfig = new File(DirectoryLayout.getInstance().getConfDir(), "runtimes.xml");
        Document document = XmlUtil.getInstance().parseReader(new FileReader(runtimeConfig));
        Element runtimesElement = (Element)document.getElementsByTagName("runtimes").item(0);
        for (Element runtimeElement : XmlUtil.getChildElements(runtimesElement, "runtime")) {
            String runtimeName = XmlUtil.getChildElement(runtimeElement, "name").getTextContent();
            logger.info((Object)("loading runtime " + runtimeName));
            if (this.runtimes.containsKey(runtimeName)) {
                logger.warn((Object)("runtime with the same name " + runtimeName + " already loaded, keeping the first one"));
                continue;
            }
            boolean runtimeDisabled = runtimeElement.getAttribute("disabled").equals("true");
            if (runtimeDisabled) {
                logger.info((Object)("runtime " + runtimeName + " disabled by config"));
            }
            Element handlerElement = XmlUtil.getChildElement(runtimeElement, "handler");
            String handlerClassName = XmlUtil.getChildElement(handlerElement, "class").getTextContent();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("workDir", workDir.toString());
            for (Element parameterElement : XmlUtil.getChildElements(handlerElement, "parameter")) {
                String paramName = XmlUtil.getChildElement(parameterElement, "name").getTextContent();
                String paramValue = XmlUtil.getChildElement(parameterElement, "value").getTextContent();
                parameters.put(paramName, paramValue);
            }
            AnalysisHandler handler = (AnalysisHandler)Class.forName(handlerClassName).getConstructor(HashMap.class).newInstance(parameters);
            if (handler.isDisabled()) {
                runtimeDisabled = true;
                logger.info((Object)("runtime " + runtimeName + " disabled as handler is disabled"));
            }
            ToolRuntime runtime = new ToolRuntime(runtimeName, handler, runtimeDisabled);
            this.runtimes.put(runtimeName, runtime);
        }
    }

    private void loadTools() throws IOException, SAXException, ParserConfigurationException {
        logger.info((Object)"loading tools");
        File toolConfig = new File(DirectoryLayout.getInstance().getConfDir(), "tools.xml");
        Document document = XmlUtil.getInstance().parseReader(new FileReader(toolConfig));
        Element toolsElement = (Element)document.getElementsByTagName("tools").item(0);
        int totalCount = 0;
        int successfullyLoadedCount = 0;
        int hiddenCount = 0;
        int disabledCount = 0;
        for (Element toolElement : XmlUtil.getChildElements(toolsElement, "tool")) {
            AnalysisDescription description;
            ++totalCount;
            String sourceResourceName = toolElement.getTextContent();
            logger.debug((Object)("loading " + sourceResourceName));
            String runtimeName = toolElement.getAttribute("runtime");
            boolean toolDisabled = toolElement.getAttribute("disabled").equals("true");
            boolean toolHidden = toolElement.getAttribute("hidden").equals("true");
            ToolRuntime runtime = this.runtimes.get(runtimeName);
            if (runtime == null) {
                logger.warn((Object)("loading " + sourceResourceName + " failed, could not find runtime " + runtimeName));
                continue;
            }
            try {
                description = runtime.getHandler().handle(sourceResourceName);
            }
            catch (Exception e) {
                logger.warn((Object)("loading " + sourceResourceName + " failed, could not create description"), (Throwable)e);
                continue;
            }
            if (this.descriptions.containsKey(description.getFullName())) {
                logger.warn((Object)("loading " + sourceResourceName + " failed, description with the name " + description.getFullName() + " already exists"));
                continue;
            }
            this.descriptions.put(description.getFullName(), description);
            ++successfullyLoadedCount;
            String disabledStatus = "";
            if (!runtime.isDisabled() && !toolDisabled) {
                this.supportedDescriptions.put(description.getFullName(), description);
            } else {
                disabledStatus = " DISABLED";
                ++disabledCount;
            }
            String hiddenStatus = "";
            if (!toolHidden) {
                this.visibleDescriptions.put(description.getFullName(), description);
            } else {
                hiddenStatus = " HIDDEN";
                ++hiddenCount;
            }
            logger.info((Object)("loaded " + description.getFullName().replace("\"", "") + " " + description.getSourceResourceFullPath() + disabledStatus + hiddenStatus));
        }
        logger.info((Object)("loaded " + successfullyLoadedCount + "/" + totalCount + " tools, " + disabledCount + " disabled, " + hiddenCount + " hidden"));
    }
}

