/*
 * Decompiled with CFR 0.152.
 */
package com.nexes.wizard;

import com.nexes.wizard.WizardPanelDescriptor;
import com.nexes.wizard.WizardPanelNotFoundException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;

public class WizardModel {
    public static final String CURRENT_PANEL_DESCRIPTOR_PROPERTY = "currentPanelDescriptorProperty";
    public static final String BACK_BUTTON_TEXT_PROPERTY = "backButtonTextProperty";
    public static final String BACK_BUTTON_ENABLED_PROPERTY = "backButtonEnabledProperty";
    public static final String NEXT_BUTTON_TEXT_PROPERTY = "nextButtonTextProperty";
    public static final String NEXT_BUTTON_ENABLED_PROPERTY = "nextButtonEnabledProperty";
    public static final String FINISH_BUTTON_TEXT_PROPERTY = "finishButtonTextProperty";
    public static final String FINISH_BUTTON_ENABLED_PROPERTY = "finishButtonEnabledProperty";
    public static final String CANCEL_BUTTON_TEXT_PROPERTY = "cancelButtonTextProperty";
    public static final String CANCEL_BUTTON_ENABLED_PROPERTY = "cancelButtonEnabledProperty";
    private WizardPanelDescriptor currentPanel;
    private HashMap<Object, WizardPanelDescriptor> panelHashmap = new HashMap();
    Object backButtonText;
    Object nextButtonText;
    Object finishButtonText;
    Object cancelButtonText;
    private Boolean backButtonEnabled;
    private Boolean nextButtonEnabled;
    private Boolean finishButtonEnabled;
    private Boolean cancelButtonEnabled;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    WizardPanelDescriptor getCurrentPanelDescriptor() {
        return this.currentPanel;
    }

    void registerPanel(Object id, WizardPanelDescriptor descriptor) {
        this.panelHashmap.put(id, descriptor);
    }

    boolean setCurrentPanel(Object id) {
        WizardPanelDescriptor nextPanel = this.panelHashmap.get(id);
        if (nextPanel == null) {
            throw new WizardPanelNotFoundException();
        }
        WizardPanelDescriptor oldPanel = this.currentPanel;
        this.currentPanel = nextPanel;
        if (oldPanel != this.currentPanel) {
            this.firePropertyChange(CURRENT_PANEL_DESCRIPTOR_PROPERTY, oldPanel, this.currentPanel);
        }
        return true;
    }

    Object getBackButtonText() {
        return this.backButtonText;
    }

    void setBackButtonText(Object newText) {
        Object oldText = this.backButtonText;
        if (!newText.equals(oldText)) {
            this.backButtonText = newText;
            this.firePropertyChange(BACK_BUTTON_TEXT_PROPERTY, oldText, newText);
        }
    }

    Object getNextButtonText() {
        return this.nextButtonText;
    }

    void setNextButtonText(Object newText) {
        Object oldText = this.nextButtonText;
        if (!newText.equals(oldText)) {
            this.nextButtonText = newText;
            this.firePropertyChange(NEXT_BUTTON_TEXT_PROPERTY, oldText, newText);
        }
    }

    Object getFinishButtonText() {
        return this.finishButtonText;
    }

    void setFinishButtonText(Object newText) {
        Object oldText = this.finishButtonText;
        if (!newText.equals(oldText)) {
            this.finishButtonText = newText;
            this.firePropertyChange(FINISH_BUTTON_TEXT_PROPERTY, oldText, newText);
        }
    }

    Object getCancelButtonText() {
        return this.cancelButtonText;
    }

    void setCancelButtonText(Object newText) {
        Object oldText = this.cancelButtonText;
        if (!newText.equals(oldText)) {
            this.cancelButtonText = newText;
            this.firePropertyChange(CANCEL_BUTTON_TEXT_PROPERTY, oldText, newText);
        }
    }

    Boolean getBackButtonEnabled() {
        return this.backButtonEnabled;
    }

    void setBackButtonEnabled(Boolean newValue) {
        Boolean oldValue = this.backButtonEnabled;
        if (newValue != oldValue) {
            this.backButtonEnabled = newValue;
            this.firePropertyChange(BACK_BUTTON_ENABLED_PROPERTY, oldValue, newValue);
        }
    }

    Boolean getNextButtonEnabled() {
        return this.nextButtonEnabled;
    }

    void setNextButtonEnabled(Boolean newValue) {
        Boolean oldValue = this.nextButtonEnabled;
        if (newValue != oldValue) {
            this.nextButtonEnabled = newValue;
            this.firePropertyChange(NEXT_BUTTON_ENABLED_PROPERTY, oldValue, newValue);
        }
    }

    Boolean getFinishButtonEnabled() {
        return this.finishButtonEnabled;
    }

    void setFinishButtonEnabled(Boolean newValue) {
        Boolean oldValue = this.finishButtonEnabled;
        if (newValue != oldValue) {
            this.finishButtonEnabled = newValue;
            this.firePropertyChange(FINISH_BUTTON_ENABLED_PROPERTY, oldValue, newValue);
        }
    }

    Boolean getCancelButtonEnabled() {
        return this.cancelButtonEnabled;
    }

    void setCancelButtonEnabled(Boolean newValue) {
        Boolean oldValue = this.cancelButtonEnabled;
        if (newValue != oldValue) {
            this.cancelButtonEnabled = newValue;
            this.firePropertyChange(CANCEL_BUTTON_ENABLED_PROPERTY, oldValue, newValue);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener p) {
        this.propertyChangeSupport.addPropertyChangeListener(p);
    }

    public void removePropertyChangeListener(PropertyChangeListener p) {
        this.propertyChangeSupport.removePropertyChangeListener(p);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

