/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote.strprotocol;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.remote.strprotocol.IStringMessage;
import org.testng.remote.strprotocol.MessageHelper;

public class TestResultMessage
implements IStringMessage {
    private static final Object[] EMPTY_PARAMS = new Object[0];
    private static final Class[] EMPTY_TYPES = new Class[0];
    protected int m_messageType;
    protected String m_suiteName;
    protected String m_testName;
    protected String m_testClassName;
    protected String m_testMethodName;
    protected String m_stackTrace;
    protected long m_startMillis;
    protected long m_endMillis;
    protected String[] m_parameters = new String[0];
    protected String[] m_paramTypes = new String[0];
    private String m_testDescription;

    TestResultMessage(int resultType, String suiteName, String testName, String className, String methodName, String testDescriptor, String[] params, long startMillis, long endMillis, String stackTrace) {
        this.init(resultType, suiteName, testName, className, methodName, stackTrace, startMillis, endMillis, this.extractParams(params), this.extractParamTypes(params), testDescriptor);
    }

    public TestResultMessage(String suiteName, String testName, ITestResult result) {
        String stackTrace = null;
        if (2 == result.getStatus() || 4 == result.getStatus()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Throwable cause = result.getThrowable();
            if (null != cause) {
                cause.printStackTrace(pw);
                stackTrace = sw.getBuffer().toString();
            } else {
                stackTrace = "unknown stack trace";
            }
        } else if (3 == result.getStatus() && result.getThrowable() != null && SkipException.class.isAssignableFrom(result.getThrowable().getClass())) {
            stackTrace = result.getThrowable().getMessage();
        }
        this.init(1000 + result.getStatus(), suiteName, testName, result.getTestClass().getName(), result.getMethod().getMethod().getName(), MessageHelper.replaceUnicodeCharactersWithAscii(stackTrace), result.getStartMillis(), result.getEndMillis(), this.toString(result.getParameters(), result.getMethod().getMethod().getParameterTypes()), this.toString(result.getMethod().getMethod().getParameterTypes()), MessageHelper.replaceUnicodeCharactersWithAscii(result.getName()));
    }

    public TestResultMessage(ITestContext testCtx, ITestResult result) {
        this(testCtx.getSuite().getName(), testCtx.getName(), result);
    }

    private void init(int resultType, String suiteName, String testName, String className, String methodName, String stackTrace, long startMillis, long endMillis, String[] parameters, String[] types, String testDescription) {
        this.m_messageType = resultType;
        this.m_suiteName = suiteName;
        this.m_testName = testName;
        this.m_testClassName = className;
        this.m_testMethodName = methodName;
        this.m_stackTrace = stackTrace;
        this.m_startMillis = startMillis;
        this.m_endMillis = endMillis;
        this.m_parameters = parameters;
        this.m_paramTypes = types;
        this.m_testDescription = testDescription;
    }

    public int getResult() {
        return this.m_messageType;
    }

    public String getMessageAsString() {
        StringBuffer buf = new StringBuffer();
        StringBuffer parambuf = new StringBuffer();
        if (null != this.m_parameters && this.m_parameters.length > 0) {
            for (int j = 0; j < this.m_parameters.length; ++j) {
                if (j > 0) {
                    parambuf.append('\u0004');
                }
                parambuf.append(this.m_paramTypes[j] + ":" + this.m_parameters[j]);
            }
        }
        buf.append(this.m_messageType).append('\u0001').append(this.m_suiteName).append('\u0001').append(this.m_testName).append('\u0001').append(this.m_testClassName).append('\u0001').append(this.m_testMethodName).append('\u0001').append(parambuf).append('\u0001').append(this.m_startMillis).append('\u0001').append(this.m_endMillis).append('\u0001').append(MessageHelper.replaceNewLine(this.m_stackTrace)).append('\u0001').append(MessageHelper.replaceNewLine(this.m_testDescription));
        return buf.toString();
    }

    public String getSuiteName() {
        return this.m_suiteName;
    }

    public String getTestClass() {
        return this.m_testClassName;
    }

    public String getMethod() {
        return this.m_testMethodName;
    }

    public String getName() {
        return this.m_testName;
    }

    public String getStackTrace() {
        return this.m_stackTrace;
    }

    public long getEndMillis() {
        return this.m_endMillis;
    }

    public long getStartMillis() {
        return this.m_startMillis;
    }

    public String[] getParameters() {
        return this.m_parameters;
    }

    public String[] getParameterTypes() {
        return this.m_paramTypes;
    }

    public String getTestDescription() {
        return this.m_testDescription;
    }

    public String toDisplayString() {
        StringBuffer buf = new StringBuffer(this.m_testMethodName);
        if (null != this.m_parameters && this.m_parameters.length > 0) {
            buf.append("(");
            for (int i = 0; i < this.m_parameters.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                if ("java.lang.String".equals(this.m_paramTypes[i]) && !"null".equals(this.m_parameters[i]) && !"\"\"".equals(this.m_parameters[i])) {
                    buf.append("\"").append(this.m_parameters[i]).append("\"");
                    continue;
                }
                buf.append(this.m_parameters[i]);
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestResultMessage that = (TestResultMessage)o;
        if (this.m_suiteName != null ? !this.m_suiteName.equals(that.m_suiteName) : that.m_suiteName != null) {
            return false;
        }
        if (this.m_testName != null ? !this.m_testName.equals(that.m_testName) : that.m_testName != null) {
            return false;
        }
        if (this.m_testClassName != null ? !this.m_testClassName.equals(that.m_testClassName) : that.m_testClassName != null) {
            return false;
        }
        String toDisplayString = this.toDisplayString();
        return !(toDisplayString != null ? !toDisplayString.equals(that.toDisplayString()) : that.toDisplayString() != null);
    }

    public int hashCode() {
        int result = this.m_suiteName != null ? this.m_suiteName.hashCode() : 0;
        result = 29 * result + (this.m_testName != null ? this.m_testName.hashCode() : 0);
        result = 29 * result + this.m_testClassName.hashCode();
        result = 29 * result + this.toDisplayString().hashCode();
        return result;
    }

    private String[] toString(Object[] objects, Class[] objectClasses) {
        if (null == objects) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>(objects.length);
        for (Object o : objects) {
            if (null == o) {
                result.add("null");
                continue;
            }
            String tostring = o.toString();
            if ("".equals(tostring)) {
                result.add("\"\"");
                continue;
            }
            result.add(MessageHelper.replaceNewLine(tostring));
        }
        return result.toArray(new String[result.size()]);
    }

    private String[] toString(Class[] classes) {
        if (null == classes) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>(classes.length);
        for (Class cls : classes) {
            result.add(cls.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    private String[] extractParamTypes(String[] params) {
        ArrayList<String> result = new ArrayList<String>(params.length);
        for (String s : params) {
            result.add(s.substring(0, s.indexOf(58)));
        }
        return result.toArray(new String[result.size()]);
    }

    private String[] extractParams(String[] params) {
        ArrayList<String> result = new ArrayList<String>(params.length);
        for (String s : params) {
            result.add(MessageHelper.replaceNewLineReplacer(s.substring(s.indexOf(58) + 1)));
        }
        return result.toArray(new String[result.size()]);
    }
}

