/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.kaha.impl.data.DataManagerImpl;
import org.apache.activemq.kaha.impl.index.DiskIndexLinkedList;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexLinkedList;
import org.apache.activemq.kaha.impl.index.IndexManager;
import org.apache.activemq.kaha.impl.index.VMIndexLinkedListTest;
import org.apache.activemq.util.IOHelper;

public class DiskIndexLinkedListTest
extends VMIndexLinkedListTest {
    private IndexManager im;

    protected IndexLinkedList createList(IndexItem root) throws IOException {
        String dirName = System.getProperty("basedir", ".") + "/target/activemq-data/testIndex";
        File file = new File(dirName);
        file.mkdirs();
        IOHelper.deleteChildren(file);
        DataManagerImpl dm = new DataManagerImpl(file, "test", new AtomicLong());
        this.im = new IndexManager(file, "test", "rw", dm, new AtomicLong());
        root = this.im.createNewIndex();
        this.im.storeIndex(root);
        return new DiskIndexLinkedList(this.im, root);
    }

    IndexItem createIndex(IndexLinkedList indexList, int offset) throws IOException {
        IndexItem result = this.im.createNewIndex();
        this.im.storeIndex(result);
        return result;
    }

    protected void addToList(IndexLinkedList list, IndexItem item) throws IOException {
        IndexItem root = list.getRoot();
        IndexItem prev = list.getLast();
        prev = prev != null ? prev : root;
        IndexItem next = list.getNextEntry(prev);
        prev.setNextItem(item.getOffset());
        item.setPreviousItem(prev.getOffset());
        this.im.updateIndexes(prev);
        if (next != null) {
            next.setPreviousItem(item.getOffset());
            item.setNextItem(next.getOffset());
            this.im.updateIndexes(next);
        }
        this.im.storeIndex(item);
        list.add(item);
    }

    protected void insertToList(IndexLinkedList list, int pos, IndexItem item) throws IOException {
        IndexItem root = list.getRoot();
        IndexItem prev = null;
        IndexItem next = null;
        if (pos <= 0) {
            prev = root;
            next = list.getNextEntry(root);
        } else if (pos >= list.size()) {
            prev = list.getLast();
            if (prev == null) {
                prev = root;
            }
            next = null;
        } else {
            prev = list.get(pos);
            prev = prev != null ? prev : root;
            next = list.getNextEntry(prev);
        }
        prev.setNextItem(item.getOffset());
        item.setPreviousItem(prev.getOffset());
        this.im.updateIndexes(prev);
        if (next != null) {
            next.setPreviousItem(item.getOffset());
            item.setNextItem(next.getOffset());
            this.im.updateIndexes(next);
        }
        this.im.storeIndex(item);
        list.setRoot(root);
        list.add(pos, item);
    }

    protected void insertFirst(IndexLinkedList list, IndexItem item) throws IOException {
        IndexItem root;
        IndexItem prev = root = list.getRoot();
        IndexItem next = list.getNextEntry(prev);
        prev.setNextItem(item.getOffset());
        item.setPreviousItem(prev.getOffset());
        this.im.updateIndexes(prev);
        if (next != null) {
            next.setPreviousItem(item.getOffset());
            item.setNextItem(next.getOffset());
            this.im.updateIndexes(next);
        }
        this.im.storeIndex(item);
        list.addFirst(item);
    }

    protected synchronized void remove(IndexLinkedList list, IndexItem item) throws IOException {
        IndexItem root = list.getRoot();
        IndexItem prev = list.getPrevEntry(item);
        IndexItem next = list.getNextEntry(item);
        list.remove(item);
        prev = prev == null ? root : prev;
        IndexItem indexItem = next = next == null || !next.equals(root) ? next : null;
        if (next != null) {
            prev.setNextItem(next.getOffset());
            next.setPreviousItem(prev.getOffset());
            this.im.updateIndexes(next);
        } else {
            prev.setNextItem(-1L);
        }
        this.im.updateIndexes(prev);
    }
}

