/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.Converter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Converter
public final class ObjectConverter {
    private ObjectConverter() {
    }

    public static boolean isCollection(Object value) {
        return value instanceof Collection || value != null && value.getClass().isArray();
    }

    @Converter
    public static Iterator iterator(Object value) {
        if (value == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.iterator();
        }
        if (value.getClass().isArray()) {
            List<Object> list = Arrays.asList((Object[])value);
            return list.iterator();
        }
        if (value instanceof NodeList) {
            final NodeList nodeList = (NodeList)value;
            return new Iterator<Node>(){
                int idx = -1;

                @Override
                public boolean hasNext() {
                    return ++this.idx < nodeList.getLength();
                }

                @Override
                public Node next() {
                    return nodeList.item(this.idx);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return Collections.singletonList(value).iterator();
    }

    @Converter
    public static boolean toBool(Object value) {
        Boolean answer = ObjectConverter.toBoolean(value);
        if (answer != null) {
            return answer;
        }
        return false;
    }

    @Converter
    public static Boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return "true".equalsIgnoreCase(value.toString()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Converter
    public static Boolean toBoolean(Boolean value) {
        if (value != null) {
            return (boolean)value;
        }
        return false;
    }

    @Converter
    public static Byte toByte(Object value) {
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.byteValue();
        }
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        return null;
    }

    @Converter
    public static byte[] toByteArray(String value) {
        return value.getBytes();
    }

    @Converter
    public static char[] toCharArray(String value) {
        return value.toCharArray();
    }

    @Converter
    public static String fromCharArray(char[] value) {
        return new String(value);
    }

    @Converter
    public static Short toShort(Object value) {
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.shortValue();
        }
        if (value instanceof String) {
            return Short.parseShort((String)value);
        }
        return null;
    }

    @Converter
    public static Integer toInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        return null;
    }

    @Converter
    public static Long toLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        return null;
    }

    @Converter
    public static Float toFloat(Object value) {
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Float.valueOf(number.floatValue());
        }
        if (value instanceof String) {
            return Float.valueOf(Float.parseFloat((String)value));
        }
        return null;
    }

    @Converter
    public static Double toDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        return null;
    }
}

