/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ConstantProcessorBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.ProcessorFactory;
import org.apache.camel.processor.DeadLetterChannel;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.LoggingLevel;
import org.apache.camel.processor.RecipientList;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeadLetterChannelBuilder
extends ErrorHandlerBuilderSupport {
    private RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
    private ProcessorFactory deadLetterFactory;
    private Processor defaultDeadLetterEndpoint;
    private Expression defaultDeadLetterEndpointExpression;
    private String defaultDeadLetterEndpointUri = "log:org.apache.camel.DeadLetterChannel?level=error";
    private Logger logger = DeadLetterChannel.createDefaultLogger();

    public DeadLetterChannelBuilder() {
    }

    public DeadLetterChannelBuilder(Processor processor) {
        this(new ConstantProcessorBuilder(processor));
    }

    public DeadLetterChannelBuilder(ProcessorFactory deadLetterFactory) {
        this.deadLetterFactory = deadLetterFactory;
    }

    public ErrorHandlerBuilder copy() {
        DeadLetterChannelBuilder answer = new DeadLetterChannelBuilder(this.deadLetterFactory);
        answer.setRedeliveryPolicy(this.getRedeliveryPolicy().copy());
        return answer;
    }

    public Processor createErrorHandler(Processor processor) throws Exception {
        Processor deadLetter = this.getDeadLetterFactory().createProcessor();
        DeadLetterChannel answer = new DeadLetterChannel(processor, deadLetter, this.getRedeliveryPolicy(), this.getLogger());
        this.configure(answer);
        return answer;
    }

    public DeadLetterChannelBuilder backOffMultiplier(double backOffMultiplier) {
        this.getRedeliveryPolicy().backOffMultiplier(backOffMultiplier);
        return this;
    }

    public DeadLetterChannelBuilder collisionAvoidancePercent(short collisionAvoidancePercent) {
        this.getRedeliveryPolicy().collisionAvoidancePercent(collisionAvoidancePercent);
        return this;
    }

    public DeadLetterChannelBuilder initialRedeliveryDelay(long initialRedeliveryDelay) {
        this.getRedeliveryPolicy().initialRedeliveryDelay(initialRedeliveryDelay);
        return this;
    }

    public DeadLetterChannelBuilder maximumRedeliveries(int maximumRedeliveries) {
        this.getRedeliveryPolicy().maximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public DeadLetterChannelBuilder useCollisionAvoidance() {
        this.getRedeliveryPolicy().useCollisionAvoidance();
        return this;
    }

    public DeadLetterChannelBuilder useExponentialBackOff() {
        this.getRedeliveryPolicy().useExponentialBackOff();
        return this;
    }

    public DeadLetterChannelBuilder logger(Logger logger) {
        this.setLogger(logger);
        return this;
    }

    public DeadLetterChannelBuilder loggingLevel(LoggingLevel level) {
        this.getLogger().setLevel(level);
        return this;
    }

    public DeadLetterChannelBuilder log(Log log) {
        this.getLogger().setLog(log);
        return this;
    }

    public DeadLetterChannelBuilder log(String log) {
        return this.log(LogFactory.getLog((String)log));
    }

    public DeadLetterChannelBuilder log(Class log) {
        return this.log(LogFactory.getLog((Class)log));
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public ProcessorFactory getDeadLetterFactory() {
        if (this.deadLetterFactory == null) {
            this.deadLetterFactory = new ProcessorFactory(){

                public Processor createProcessor() {
                    return DeadLetterChannelBuilder.this.getDefaultDeadLetterEndpoint();
                }
            };
        }
        return this.deadLetterFactory;
    }

    public void setDeadLetterFactory(ProcessorFactory deadLetterFactory) {
        this.deadLetterFactory = deadLetterFactory;
    }

    public Processor getDefaultDeadLetterEndpoint() {
        if (this.defaultDeadLetterEndpoint == null) {
            this.defaultDeadLetterEndpoint = new RecipientList(this.getDefaultDeadLetterEndpointExpression());
        }
        return this.defaultDeadLetterEndpoint;
    }

    public void setDefaultDeadLetterEndpoint(Processor defaultDeadLetterEndpoint) {
        this.defaultDeadLetterEndpoint = defaultDeadLetterEndpoint;
    }

    public Expression getDefaultDeadLetterEndpointExpression() {
        if (this.defaultDeadLetterEndpointExpression == null) {
            this.defaultDeadLetterEndpointExpression = ExpressionBuilder.constantExpression(this.getDefaultDeadLetterEndpointUri());
        }
        return this.defaultDeadLetterEndpointExpression;
    }

    public void setDefaultDeadLetterEndpointExpression(Expression defaultDeadLetterEndpointExpression) {
        this.defaultDeadLetterEndpointExpression = defaultDeadLetterEndpointExpression;
    }

    public String getDefaultDeadLetterEndpointUri() {
        return this.defaultDeadLetterEndpointUri;
    }

    public void setDefaultDeadLetterEndpointUri(String defaultDeadLetterEndpointUri) {
        this.defaultDeadLetterEndpointUri = defaultDeadLetterEndpointUri;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

