/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.xbean;

import java.net.URI;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;

public class JDBCPersistenceXBeanConfigTest
extends TestCase {
    protected BrokerService brokerService;

    public void testManagmentContextConfiguredCorrectly() throws Exception {
        PersistenceAdapter persistenceAdapter = this.brokerService.getPersistenceAdapter();
        JDBCPersistenceXBeanConfigTest.assertNotNull((Object)persistenceAdapter);
        JDBCPersistenceXBeanConfigTest.assertTrue((boolean)(persistenceAdapter instanceof JDBCPersistenceAdapter));
        JDBCPersistenceAdapter jpa = (JDBCPersistenceAdapter)persistenceAdapter;
        JDBCPersistenceXBeanConfigTest.assertEquals((String)"BROKER1.", (String)jpa.getStatements().getTablePrefix());
    }

    protected void setUp() throws Exception {
        this.brokerService = this.createBroker();
        this.brokerService.start();
    }

    protected void tearDown() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    protected BrokerService createBroker() throws Exception {
        String uri = "org/apache/activemq/xbean/jdbc-persistence-test.xml";
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }
}

