/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs.amq1095;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import junit.framework.Assert;
import org.apache.activemq.bugs.amq1095.ActiveMQTestCase;

public class MessageSelectorTest
extends ActiveMQTestCase {
    private MessageConsumer consumer1;
    private MessageConsumer consumer2;

    public MessageSelectorTest() {
    }

    public MessageSelectorTest(String name) {
        super(name);
    }

    public void testMessageSelectorForDurableSubscribersRunA() {
        this.runMessageSelectorTest(true);
    }

    public void testMessageSelectorForDurableSubscribersRunB() {
        this.runMessageSelectorTest(true);
    }

    public void testMessageSelectorForNonDurableSubscribers() {
        this.runMessageSelectorTest(false);
    }

    private void runMessageSelectorTest(boolean isDurableSubscriber) {
        try {
            TextMessage msg2;
            String contents;
            int propertyValue;
            StringBuffer msg;
            String PROPERTY_CONSUMER = "consumer";
            String CONSUMER_1 = "Consumer 1";
            String CONSUMER_2 = "Consumer 2";
            String MESSAGE_1 = "Message to Consumer 1";
            String MESSAGE_2 = "Message to Consumer 2";
            MessageSelectorTest.assertNotNull((Object)this.connection);
            MessageSelectorTest.assertNotNull((Object)this.destination);
            Session producingSession = this.connection.createSession(false, 1);
            MessageProducer producer = producingSession.createProducer(this.destination);
            Session consumingSession1 = this.connection.createSession(false, 1);
            Session consumingSession2 = this.connection.createSession(false, 1);
            if (isDurableSubscriber) {
                this.consumer1 = consumingSession1.createDurableSubscriber((Topic)this.destination, "Consumer 1", "consumer = 1", false);
                this.consumer2 = consumingSession2.createDurableSubscriber((Topic)this.destination, "Consumer 2", "consumer = 2", false);
            } else {
                this.consumer1 = consumingSession1.createConsumer(this.destination, "consumer = 1");
                this.consumer2 = consumingSession2.createConsumer(this.destination, "consumer = 2");
            }
            this.registerToBeEmptiedOnShutdown(this.consumer1);
            this.registerToBeEmptiedOnShutdown(this.consumer2);
            this.connection.start();
            TextMessage msg1 = (TextMessage)this.consumer1.receive(500L);
            if (msg1 != null) {
                msg = new StringBuffer("The consumer read a message that was left over from a former ActiveMQ broker run.");
                propertyValue = msg1.getIntProperty("consumer");
                contents = msg1.getText();
                if (propertyValue != 1) {
                    msg.append(" That message does not match the consumer's message selector.");
                    MessageSelectorTest.fail((String)msg.toString());
                }
                MessageSelectorTest.assertEquals((int)1, (int)propertyValue);
                MessageSelectorTest.assertEquals((String)"Message to Consumer 1", (String)contents);
            }
            if ((msg2 = (TextMessage)this.consumer2.receive(500L)) != null) {
                msg = new StringBuffer("The consumer read a message that was left over from a former ActiveMQ broker run.");
                propertyValue = msg2.getIntProperty("consumer");
                contents = msg2.getText();
                if (propertyValue != 2) {
                    msg.append(" That message does not match the consumer's message selector.");
                    MessageSelectorTest.fail((String)msg.toString());
                }
                MessageSelectorTest.assertEquals((int)2, (int)propertyValue);
                MessageSelectorTest.assertEquals((String)"Message to Consumer 2", (String)contents);
            }
            msg = producingSession.createTextMessage();
            msg.setText("Message to Consumer 1");
            msg.setIntProperty("consumer", 1);
            producer.send((Message)msg);
            msg = producingSession.createTextMessage();
            msg.setText("Message to Consumer 2");
            msg.setIntProperty("consumer", 2);
            producer.send((Message)msg);
            msg1 = (TextMessage)this.consumer1.receive(500L);
            MessageSelectorTest.assertNotNull((Object)msg1);
            propertyValue = msg1.getIntProperty("consumer");
            contents = msg1.getText();
            MessageSelectorTest.assertEquals((int)1, (int)propertyValue);
            MessageSelectorTest.assertEquals((String)"Message to Consumer 1", (String)contents);
            msg1 = (TextMessage)this.consumer1.receive(500L);
            MessageSelectorTest.assertNull((Object)msg1);
            msg2 = (TextMessage)this.consumer2.receive(500L);
            MessageSelectorTest.assertNotNull((Object)msg2);
            propertyValue = msg2.getIntProperty("consumer");
            contents = msg2.getText();
            MessageSelectorTest.assertEquals((int)2, (int)propertyValue);
            MessageSelectorTest.assertEquals((String)"Message to Consumer 2", (String)contents);
            msg2 = (TextMessage)this.consumer2.receive(500L);
            MessageSelectorTest.assertNull((Object)msg2);
        }
        catch (JMSException ex) {
            ex.printStackTrace();
            Assert.fail();
        }
    }
}

