/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.advisory;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.advisory.DestinationEvent;
import org.apache.activemq.advisory.DestinationListener;
import org.apache.activemq.advisory.DestinationSource;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class DestinationListenerTest
extends EmbeddedBrokerTestSupport
implements DestinationListener {
    private static final transient Log LOG = LogFactory.getLog(DestinationListenerTest.class);
    protected ActiveMQConnection connection;
    protected ActiveMQQueue sampleQueue = new ActiveMQQueue("foo.bar");
    protected ActiveMQTopic sampleTopic = new ActiveMQTopic("cheese");
    protected List<ActiveMQDestination> newDestinations = new ArrayList<ActiveMQDestination>();

    public void testDestiationSourceHasInitialDestinations() throws Exception {
        Thread.sleep(1000L);
        DestinationSource destinationSource = this.connection.getDestinationSource();
        Set queues = destinationSource.getQueues();
        Set topics = destinationSource.getTopics();
        LOG.info((Object)("Queues: " + queues));
        LOG.info((Object)("Topics: " + topics));
        DestinationListenerTest.assertTrue((String)"The queues should not be empty!", (!queues.isEmpty() ? 1 : 0) != 0);
        DestinationListenerTest.assertTrue((String)"The topics should not be empty!", (!topics.isEmpty() ? 1 : 0) != 0);
        DestinationListenerTest.assertTrue((String)("queues contains initial queue: " + queues), (boolean)queues.contains(this.sampleQueue));
        DestinationListenerTest.assertTrue((String)("topics contains initial topic: " + queues), (boolean)topics.contains(this.sampleTopic));
    }

    public void testConsumerForcesNotificationOfNewDestination() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue newQueue = new ActiveMQQueue("Test.Cheese");
        session.createConsumer((Destination)newQueue);
        Thread.sleep(3000L);
        MatcherAssert.assertThat((Object)newQueue, (Matcher)Matchers.isIn(this.newDestinations));
        LOG.info((Object)("New destinations are: " + this.newDestinations));
    }

    public void testProducerForcesNotificationOfNewDestination() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue newQueue = new ActiveMQQueue("Test.Beer");
        MessageProducer producer = session.createProducer((Destination)newQueue);
        TextMessage message = session.createTextMessage("<hello>world</hello>");
        producer.send((Message)message);
        Thread.sleep(3000L);
        MatcherAssert.assertThat((Object)newQueue, (Matcher)Matchers.isIn(this.newDestinations));
        LOG.info((Object)("New destinations are: " + this.newDestinations));
    }

    public void onDestinationEvent(DestinationEvent event) {
        ActiveMQDestination destination = event.getDestination();
        if (event.isAddOperation()) {
            LOG.info((Object)("Added:   " + destination));
            this.newDestinations.add(destination);
        } else {
            LOG.info((Object)("Removed: " + destination));
            this.newDestinations.remove(destination);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.connection = (ActiveMQConnection)this.createConnection();
        this.connection.start();
        this.connection.getDestinationSource().setDestinationListener((DestinationListener)this);
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        broker.setDestinations(new ActiveMQDestination[]{this.sampleQueue, this.sampleTopic});
        return broker;
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }
}

