/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadTestBurnIn
extends JmsTestSupport {
    private static final transient Log LOG = LogFactory.getLog(LoadTestBurnIn.class);
    public ActiveMQDestination destination;
    public int deliveryMode;
    public byte destinationType;
    public boolean durableConsumer;
    public int messageCount = 50000;
    public int messageSize = 1024;

    public static Test suite() {
        return LoadTestBurnIn.suite(LoadTestBurnIn.class);
    }

    protected void setUp() throws Exception {
        LOG.info((Object)("Start: " + this.getName()));
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        catch (Throwable e) {
            e.printStackTrace(System.out);
        }
        finally {
            LOG.info((Object)("End: " + this.getName()));
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LoadTestBurnIn.suite());
    }

    protected BrokerService createBroker() throws Exception {
        return BrokerFactory.createBroker((URI)new URI("broker://(tcp://localhost:0)?useJmx=true"));
    }

    protected ConnectionFactory createConnectionFactory() throws URISyntaxException, IOException {
        return new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getServer().getConnectURI());
    }

    public void initCombosForTestSendReceive() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)2});
        this.addCombinationValues("durableConsumer", new Object[]{Boolean.TRUE});
        this.addCombinationValues("messageSize", new Object[]{101, 102, 103, 104, 105, 106, 107, 108});
    }

    public void testSendReceive() throws Exception {
        if (this.durableConsumer && this.destinationType != 2) {
            return;
        }
        this.connection.setClientID(this.getName());
        this.connection.getPrefetchPolicy().setAll(1000);
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination(session, this.destinationType);
        Object consumer = this.durableConsumer ? session.createDurableSubscriber((Topic)this.destination, "sub1:" + System.currentTimeMillis()) : session.createConsumer((Destination)this.destination);
        this.profilerPause("Ready: ");
        final CountDownLatch producerDoneLatch = new CountDownLatch(1);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Connection connection2 = null;
                try {
                    connection2 = LoadTestBurnIn.this.factory.createConnection();
                    Session session = connection2.createSession(false, 1);
                    MessageProducer producer = session.createProducer((Destination)LoadTestBurnIn.this.destination);
                    producer.setDeliveryMode(LoadTestBurnIn.this.deliveryMode);
                    for (int i = 0; i < LoadTestBurnIn.this.messageCount; ++i) {
                        BytesMessage m = session.createBytesMessage();
                        m.writeBytes(new byte[LoadTestBurnIn.this.messageSize]);
                        producer.send((Message)m);
                    }
                    producer.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
                finally {
                    LoadTestBurnIn.this.safeClose(connection2);
                    producerDoneLatch.countDown();
                }
            }
        }.start();
        Message message = null;
        for (int i = 0; i < this.messageCount; ++i) {
            message = consumer.receive(5000L);
            LoadTestBurnIn.assertNotNull((String)("Did not get message: " + i), (Object)message);
        }
        this.profilerPause("Done: ");
        LoadTestBurnIn.assertNull((Object)consumer.receiveNoWait());
        message.acknowledge();
        LoadTestBurnIn.assertTrue((boolean)producerDoneLatch.await(5L, TimeUnit.SECONDS));
    }
}

