/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsSendReceiveTestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsTopicSendReceiveWithTwoConnectionsTest
extends JmsSendReceiveTestSupport {
    private static final Log LOG = LogFactory.getLog(JmsTopicSendReceiveWithTwoConnectionsTest.class);
    protected Connection sendConnection;
    protected Connection receiveConnection;
    protected Session receiveSession;

    protected void setUp() throws Exception {
        super.setUp();
        this.connectionFactory = this.createConnectionFactory();
        this.sendConnection = this.createSendConnection();
        this.sendConnection.start();
        this.receiveConnection = this.createReceiveConnection();
        this.receiveConnection.start();
        LOG.info((Object)("Created sendConnection: " + this.sendConnection));
        LOG.info((Object)("Created receiveConnection: " + this.receiveConnection));
        this.session = this.sendConnection.createSession(false, 1);
        this.receiveSession = this.receiveConnection.createSession(false, 1);
        LOG.info((Object)("Created sendSession: " + this.session));
        LOG.info((Object)("Created receiveSession: " + this.receiveSession));
        this.producer = this.session.createProducer(null);
        this.producer.setDeliveryMode(this.deliveryMode);
        LOG.info((Object)("Created producer: " + this.producer + " delivery mode = " + (this.deliveryMode == 2 ? "PERSISTENT" : "NON_PERSISTENT")));
        if (this.topic) {
            this.consumerDestination = this.session.createTopic(this.getConsumerSubject());
            this.producerDestination = this.session.createTopic(this.getProducerSubject());
        } else {
            this.consumerDestination = this.session.createQueue(this.getConsumerSubject());
            this.producerDestination = this.session.createQueue(this.getProducerSubject());
        }
        LOG.info((Object)("Created  consumer destination: " + this.consumerDestination + " of type: " + this.consumerDestination.getClass()));
        LOG.info((Object)("Created  producer destination: " + this.producerDestination + " of type: " + this.producerDestination.getClass()));
        this.consumer = this.createConsumer(this.receiveSession, this.consumerDestination);
        this.consumer.setMessageListener((MessageListener)this);
        LOG.info((Object)"Started connections");
    }

    protected Connection createReceiveConnection() throws Exception {
        return this.createConnection();
    }

    protected Connection createSendConnection() throws Exception {
        return this.createConnection();
    }

    protected MessageConsumer createConsumer(Session session, Destination dest) throws JMSException {
        return session.createConsumer(dest);
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
    }

    protected void tearDown() throws Exception {
        this.session.close();
        this.receiveSession.close();
        this.sendConnection.close();
        this.receiveConnection.close();
    }
}

