/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.ConnectionClosedException;
import org.apache.activemq.advisory.ConsumerEvent;
import org.apache.activemq.advisory.ConsumerEventSource;
import org.apache.activemq.advisory.ConsumerListener;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.MessageIdList;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.springframework.core.io.Resource;

public class JmsMultipleBrokersTestSupport
extends CombinationTestSupport {
    public static final String AUTO_ASSIGN_TRANSPORT = "tcp://localhost:0";
    public static int maxSetupTime = 5000;
    protected Map<String, BrokerItem> brokers;
    protected Map<String, Destination> destinations;
    protected int messageSize = 1;
    protected boolean persistentDelivery = true;
    protected boolean verbose;

    protected NetworkConnector bridgeBrokers(String localBrokerName, String remoteBrokerName) throws Exception {
        return this.bridgeBrokers(localBrokerName, remoteBrokerName, false, 1);
    }

    protected void bridgeBrokers(String localBrokerName, String remoteBrokerName, boolean dynamicOnly) throws Exception {
        BrokerService localBroker = this.brokers.get((Object)localBrokerName).broker;
        BrokerService remoteBroker = this.brokers.get((Object)remoteBrokerName).broker;
        this.bridgeBrokers(localBroker, remoteBroker, dynamicOnly, 1);
    }

    protected NetworkConnector bridgeBrokers(String localBrokerName, String remoteBrokerName, boolean dynamicOnly, int networkTTL) throws Exception {
        BrokerService localBroker = this.brokers.get((Object)localBrokerName).broker;
        BrokerService remoteBroker = this.brokers.get((Object)remoteBrokerName).broker;
        return this.bridgeBrokers(localBroker, remoteBroker, dynamicOnly, networkTTL);
    }

    protected NetworkConnector bridgeBrokers(BrokerService localBroker, BrokerService remoteBroker, boolean dynamicOnly, int networkTTL) throws Exception {
        List transportConnectors = remoteBroker.getTransportConnectors();
        if (!transportConnectors.isEmpty()) {
            URI remoteURI = ((TransportConnector)transportConnectors.get(0)).getConnectUri();
            DiscoveryNetworkConnector connector = new DiscoveryNetworkConnector(new URI("static:" + remoteURI));
            connector.setDynamicOnly(dynamicOnly);
            connector.setNetworkTTL(networkTTL);
            localBroker.addNetworkConnector((NetworkConnector)connector);
            maxSetupTime = 2000;
            return connector;
        }
        throw new Exception("Remote broker has no registered connectors.");
    }

    protected void bridgeAllBrokers() throws Exception {
        this.bridgeAllBrokers("default");
    }

    protected void bridgeAllBrokers(String groupName) throws Exception {
        Collection<BrokerItem> brokerList = this.brokers.values();
        Iterator<BrokerItem> i = brokerList.iterator();
        while (i.hasNext()) {
            BrokerService broker = i.next().broker;
            List transportConnectors = broker.getTransportConnectors();
            if (transportConnectors.isEmpty()) {
                broker.addConnector(new URI(AUTO_ASSIGN_TRANSPORT));
                transportConnectors = broker.getTransportConnectors();
            }
            TransportConnector transport = (TransportConnector)transportConnectors.get(0);
            transport.setDiscoveryUri(new URI("multicast://" + groupName));
            broker.addNetworkConnector("multicast://" + groupName);
        }
        maxSetupTime = 8000;
    }

    protected void startAllBrokers() throws Exception {
        Collection<BrokerItem> brokerList = this.brokers.values();
        Iterator<BrokerItem> i = brokerList.iterator();
        while (i.hasNext()) {
            BrokerService broker = i.next().broker;
            broker.start();
        }
        Thread.sleep(maxSetupTime);
    }

    protected BrokerService createBroker(String brokerName) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName(brokerName);
        this.brokers.put(brokerName, new BrokerItem(broker));
        return broker;
    }

    protected BrokerService createBroker(URI brokerUri) throws Exception {
        BrokerService broker = BrokerFactory.createBroker((URI)brokerUri);
        this.brokers.put(broker.getBrokerName(), new BrokerItem(broker));
        return broker;
    }

    protected BrokerService createBroker(Resource configFile) throws Exception {
        BrokerFactoryBean brokerFactory = new BrokerFactoryBean(configFile);
        brokerFactory.afterPropertiesSet();
        BrokerService broker = brokerFactory.getBroker();
        this.brokers.put(broker.getBrokerName(), new BrokerItem(broker));
        return broker;
    }

    protected ConnectionFactory getConnectionFactory(String brokerName) throws Exception {
        BrokerItem brokerItem = this.brokers.get(brokerName);
        if (brokerItem != null) {
            return brokerItem.factory;
        }
        return null;
    }

    protected Connection createConnection(String brokerName) throws Exception {
        BrokerItem brokerItem = this.brokers.get(brokerName);
        if (brokerItem != null) {
            return brokerItem.createConnection();
        }
        return null;
    }

    protected MessageConsumer createConsumer(String brokerName, Destination dest) throws Exception {
        return this.createConsumer(brokerName, dest, null);
    }

    protected MessageConsumer createConsumer(String brokerName, Destination dest, CountDownLatch latch) throws Exception {
        BrokerItem brokerItem = this.brokers.get(brokerName);
        if (brokerItem != null) {
            return brokerItem.createConsumer(dest, latch);
        }
        return null;
    }

    protected MessageConsumer createDurableSubscriber(String brokerName, Topic dest, String name) throws Exception {
        BrokerItem brokerItem = this.brokers.get(brokerName);
        if (brokerItem != null) {
            return brokerItem.createDurableSubscriber(dest, name);
        }
        return null;
    }

    protected MessageIdList getBrokerMessages(String brokerName) {
        BrokerItem brokerItem = this.brokers.get(brokerName);
        if (brokerItem != null) {
            return brokerItem.getAllMessages();
        }
        return null;
    }

    protected MessageIdList getConsumerMessages(String brokerName, MessageConsumer consumer) {
        BrokerItem brokerItem = this.brokers.get(brokerName);
        if (brokerItem != null) {
            return brokerItem.getConsumerMessages(consumer);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertConsumersConnect(String brokerName, Destination destination, final int count, long timeout) throws Exception {
        BrokerItem brokerItem = this.brokers.get(brokerName);
        Connection conn = brokerItem.createConnection();
        conn.start();
        ConsumerEventSource ces = new ConsumerEventSource(conn, destination);
        try {
            final AtomicInteger actualConnected = new AtomicInteger();
            final CountDownLatch latch = new CountDownLatch(1);
            ces.setConsumerListener(new ConsumerListener(){

                public void onConsumerEvent(ConsumerEvent event) {
                    if (actualConnected.get() < count) {
                        actualConnected.set(event.getConsumerCount());
                    }
                    if (event.getConsumerCount() >= count) {
                        latch.countDown();
                    }
                }
            });
            ces.start();
            latch.await(timeout, TimeUnit.MILLISECONDS);
            JmsMultipleBrokersTestSupport.assertTrue((String)("Expected at least " + count + " consumers to connect, but only " + actualConnected.get() + " connectect within " + timeout + " ms"), (actualConnected.get() >= count ? 1 : 0) != 0);
        }
        finally {
            ces.stop();
            conn.close();
            brokerItem.connections.remove(conn);
        }
    }

    protected void sendMessages(String brokerName, Destination destination, int count) throws Exception {
        BrokerItem brokerItem = this.brokers.get(brokerName);
        Connection conn = brokerItem.createConnection();
        conn.start();
        Session sess = conn.createSession(false, 1);
        MessageProducer producer = brokerItem.createProducer(destination, sess);
        producer.setDeliveryMode(this.persistentDelivery ? 2 : 1);
        for (int i = 0; i < count; ++i) {
            TextMessage msg = this.createTextMessage(sess, conn.getClientID() + ": Message-" + i);
            producer.send((Message)msg);
        }
        producer.close();
        sess.close();
        conn.close();
        brokerItem.connections.remove(conn);
    }

    protected TextMessage createTextMessage(Session session, String initText) throws Exception {
        TextMessage msg = session.createTextMessage();
        if (initText.length() < this.messageSize) {
            char[] data = new char[this.messageSize - initText.length()];
            Arrays.fill(data, '*');
            String str = new String(data);
            msg.setText(initText + str);
        } else {
            msg.setText(initText);
        }
        return msg;
    }

    protected ActiveMQDestination createDestination(String name, boolean topic) throws JMSException {
        if (topic) {
            ActiveMQTopic dest = new ActiveMQTopic(name);
            this.destinations.put(name, (Destination)dest);
            return (ActiveMQDestination)dest;
        }
        ActiveMQQueue dest = new ActiveMQQueue(name);
        this.destinations.put(name, (Destination)dest);
        return (ActiveMQDestination)dest;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.brokers = new HashMap<String, BrokerItem>();
        this.destinations = new HashMap<String, Destination>();
    }

    protected void tearDown() throws Exception {
        this.destroyAllBrokers();
        super.tearDown();
    }

    protected void destroyBroker(String brokerName) throws Exception {
        BrokerItem brokerItem = this.brokers.remove(brokerName);
        if (brokerItem != null) {
            brokerItem.destroy();
        }
    }

    protected void destroyAllBrokers() throws Exception {
        for (BrokerItem brokerItem : this.brokers.values()) {
            brokerItem.destroy();
        }
        this.brokers.clear();
    }

    public class BrokerItem {
        public BrokerService broker;
        public ActiveMQConnectionFactory factory;
        public List<Connection> connections;
        public Map<MessageConsumer, MessageIdList> consumers;
        public MessageIdList allMessages = new MessageIdList();
        public boolean persistent;
        private IdGenerator id;

        public BrokerItem(BrokerService broker) throws Exception {
            this.broker = broker;
            this.factory = new ActiveMQConnectionFactory(broker.getVmConnectorURI());
            this.consumers = Collections.synchronizedMap(new HashMap());
            this.connections = Collections.synchronizedList(new ArrayList());
            this.allMessages.setVerbose(JmsMultipleBrokersTestSupport.this.verbose);
            this.id = new IdGenerator(broker.getBrokerName() + ":");
        }

        public Connection createConnection() throws Exception {
            Connection conn = this.factory.createConnection();
            conn.setClientID(this.id.generateId());
            this.connections.add(conn);
            return conn;
        }

        public MessageConsumer createConsumer(Destination dest) throws Exception {
            return this.createConsumer(dest, null);
        }

        public MessageConsumer createConsumer(Destination dest, CountDownLatch latch) throws Exception {
            Connection c = this.createConnection();
            c.start();
            Session s = c.createSession(false, 1);
            return this.createConsumerWithSession(dest, s, latch);
        }

        public MessageConsumer createConsumerWithSession(Destination dest, Session sess) throws Exception {
            return this.createConsumerWithSession(dest, sess, null);
        }

        public MessageConsumer createConsumerWithSession(Destination dest, Session sess, CountDownLatch latch) throws Exception {
            MessageConsumer client = sess.createConsumer(dest);
            MessageIdList messageIdList = new MessageIdList();
            messageIdList.setCountDownLatch(latch);
            messageIdList.setParent(this.allMessages);
            client.setMessageListener((MessageListener)messageIdList);
            this.consumers.put(client, messageIdList);
            return client;
        }

        public MessageConsumer createDurableSubscriber(Topic dest, String name) throws Exception {
            Connection c = this.createConnection();
            c.start();
            Session s = c.createSession(false, 1);
            return this.createDurableSubscriber(dest, s, name);
        }

        public MessageConsumer createDurableSubscriber(Topic dest, Session sess, String name) throws Exception {
            TopicSubscriber client = sess.createDurableSubscriber(dest, name);
            MessageIdList messageIdList = new MessageIdList();
            messageIdList.setParent(this.allMessages);
            client.setMessageListener((MessageListener)messageIdList);
            this.consumers.put((MessageConsumer)client, messageIdList);
            return client;
        }

        public MessageIdList getAllMessages() {
            return this.allMessages;
        }

        public MessageIdList getConsumerMessages(MessageConsumer consumer) {
            return this.consumers.get(consumer);
        }

        public MessageProducer createProducer(Destination dest) throws Exception {
            Connection c = this.createConnection();
            c.start();
            Session s = c.createSession(false, 1);
            return this.createProducer(dest, s);
        }

        public MessageProducer createProducer(Destination dest, Session sess) throws Exception {
            MessageProducer client = sess.createProducer(dest);
            client.setDeliveryMode(this.persistent ? 2 : 1);
            return client;
        }

        public void destroy() throws Exception {
            while (!this.connections.isEmpty()) {
                Connection c = this.connections.remove(0);
                try {
                    c.close();
                }
                catch (ConnectionClosedException connectionClosedException) {}
            }
            this.broker.stop();
            this.consumers.clear();
            this.broker = null;
            this.connections = null;
            this.consumers = null;
            this.factory = null;
        }
    }
}

