/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.net.URI;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.BytesMessage;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.apache.activemq.usage.SystemUsage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class AMQDeadlockTest3
extends TestCase {
    private static final transient Log LOG = LogFactory.getLog(AMQDeadlockTest3.class);
    private static final String URL1 = "tcp://localhost:61616";
    private static final String URL2 = "tcp://localhost:61617";
    private static final String QUEUE1_NAME = "test.queue.1";
    private static final String QUEUE2_NAME = "test.queue.2";
    private static final int MAX_CONSUMERS = 1;
    private static final int MAX_PRODUCERS = 1;
    private static final int NUM_MESSAGE_TO_SEND = 10;
    private AtomicInteger messageCount = new AtomicInteger();
    private CountDownLatch doneLatch;

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueueLimitsWithOneBrokerSameConnection() throws Exception {
        BrokerService brokerService1 = null;
        ActiveMQConnectionFactory acf = null;
        PooledConnectionFactory pcf = null;
        DefaultMessageListenerContainer container1 = null;
        try {
            brokerService1 = this.createBrokerService("broker1", URL1, null);
            brokerService1.start();
            acf = this.createConnectionFactory(URL1);
            pcf = new PooledConnectionFactory(acf);
            this.doneLatch = new CountDownLatch(10);
            container1 = this.createDefaultMessageListenerContainer((ConnectionFactory)acf, new TestMessageListener1(500L), QUEUE1_NAME);
            container1.afterPropertiesSet();
            Thread.sleep(2000L);
            ExecutorService executor = Executors.newCachedThreadPool();
            for (int i = 0; i < 1; ++i) {
                executor.submit(new PooledProducerTask(pcf, QUEUE2_NAME));
                Thread.sleep(1000L);
                executor.submit(new PooledProducerTask(pcf, QUEUE1_NAME));
            }
            AMQDeadlockTest3.assertTrue((boolean)this.doneLatch.await(20L, TimeUnit.SECONDS));
            executor.shutdownNow();
            Assert.assertEquals((int)10, (int)this.messageCount.get());
        }
        finally {
            container1.stop();
            container1.destroy();
            container1 = null;
            brokerService1.stop();
            brokerService1 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueueLimitsWithTwoBrokerProduceandConsumeonDifferentBrokersWithOneConnectionForProducing() throws Exception {
        BrokerService brokerService1 = null;
        BrokerService brokerService2 = null;
        ActiveMQConnectionFactory acf1 = null;
        ActiveMQConnectionFactory acf2 = null;
        PooledConnectionFactory pcf = null;
        DefaultMessageListenerContainer container1 = null;
        try {
            brokerService1 = this.createBrokerService("broker1", URL1, URL2);
            brokerService1.start();
            brokerService2 = this.createBrokerService("broker2", URL2, URL1);
            brokerService2.start();
            acf1 = this.createConnectionFactory(URL1);
            acf2 = this.createConnectionFactory(URL2);
            pcf = new PooledConnectionFactory(acf1);
            Thread.sleep(1000L);
            this.doneLatch = new CountDownLatch(10);
            container1 = this.createDefaultMessageListenerContainer((ConnectionFactory)acf2, new TestMessageListener1(500L), QUEUE1_NAME);
            container1.afterPropertiesSet();
            ExecutorService executor = Executors.newCachedThreadPool();
            for (int i = 0; i < 1; ++i) {
                executor.submit(new PooledProducerTask(pcf, QUEUE2_NAME));
                Thread.sleep(1000L);
                executor.submit(new PooledProducerTask(pcf, QUEUE1_NAME));
            }
            AMQDeadlockTest3.assertTrue((boolean)this.doneLatch.await(20L, TimeUnit.SECONDS));
            executor.shutdownNow();
            Assert.assertEquals((int)10, (int)this.messageCount.get());
        }
        finally {
            container1.stop();
            container1.destroy();
            container1 = null;
            brokerService1.stop();
            brokerService1 = null;
            brokerService2.stop();
            brokerService2 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueueLimitsWithTwoBrokerProduceandConsumeonDifferentBrokersWithSeperateConnectionsForProducing() throws Exception {
        BrokerService brokerService1 = null;
        BrokerService brokerService2 = null;
        ActiveMQConnectionFactory acf1 = null;
        ActiveMQConnectionFactory acf2 = null;
        DefaultMessageListenerContainer container1 = null;
        DefaultMessageListenerContainer container2 = null;
        try {
            brokerService1 = this.createBrokerService("broker1", URL1, URL2);
            brokerService1.start();
            brokerService2 = this.createBrokerService("broker2", URL2, URL1);
            brokerService2.start();
            acf1 = this.createConnectionFactory(URL1);
            acf2 = this.createConnectionFactory(URL2);
            Thread.sleep(1000L);
            this.doneLatch = new CountDownLatch(10);
            container1 = this.createDefaultMessageListenerContainer((ConnectionFactory)acf2, new TestMessageListener1(500L), QUEUE1_NAME);
            container1.afterPropertiesSet();
            container2 = this.createDefaultMessageListenerContainer((ConnectionFactory)acf2, new TestMessageListener1(30000L), QUEUE2_NAME);
            container2.afterPropertiesSet();
            ExecutorService executor = Executors.newCachedThreadPool();
            for (int i = 0; i < 1; ++i) {
                executor.submit(new NonPooledProducerTask((ConnectionFactory)acf1, QUEUE2_NAME));
                Thread.sleep(1000L);
                executor.submit(new NonPooledProducerTask((ConnectionFactory)acf1, QUEUE1_NAME));
            }
            AMQDeadlockTest3.assertTrue((boolean)this.doneLatch.await(20L, TimeUnit.SECONDS));
            executor.shutdownNow();
            Assert.assertEquals((int)10, (int)this.messageCount.get());
        }
        finally {
            container1.stop();
            container1.destroy();
            container1 = null;
            container2.stop();
            container2.destroy();
            container2 = null;
            brokerService1.stop();
            brokerService1 = null;
            brokerService2.stop();
            brokerService2 = null;
        }
    }

    private BrokerService createBrokerService(String brokerName, String uri1, String uri2) throws Exception {
        BrokerService brokerService = new BrokerService();
        brokerService.setBrokerName(brokerName);
        brokerService.setPersistent(false);
        brokerService.setUseJmx(true);
        SystemUsage memoryManager = new SystemUsage();
        memoryManager.getMemoryUsage().setLimit(5000000L);
        brokerService.setSystemUsage(memoryManager);
        ArrayList<PolicyEntry> policyEntries = new ArrayList<PolicyEntry>();
        PolicyEntry entry = new PolicyEntry();
        entry.setQueue(">");
        entry.setMemoryLimit(1000L);
        policyEntries.add(entry);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setPolicyEntries(policyEntries);
        brokerService.setDestinationPolicy(policyMap);
        TransportConnector tConnector = new TransportConnector();
        tConnector.setUri(new URI(uri1));
        tConnector.setName(brokerName + ".transportConnector");
        brokerService.addConnector(tConnector);
        if (uri2 != null) {
            DiscoveryNetworkConnector nc = new DiscoveryNetworkConnector(new URI("static:" + uri2));
            nc.setBridgeTempDestinations(true);
            nc.setBrokerName(brokerName);
            brokerService.addNetworkConnector((NetworkConnector)nc);
        }
        return brokerService;
    }

    public DefaultMessageListenerContainer createDefaultMessageListenerContainer(ConnectionFactory acf, MessageListener listener, String queue) {
        DefaultMessageListenerContainer container = new DefaultMessageListenerContainer();
        container.setConnectionFactory(acf);
        container.setDestinationName(queue);
        container.setMessageListener((Object)listener);
        container.setSessionTransacted(false);
        container.setSessionAcknowledgeMode(1);
        container.setConcurrentConsumers(1);
        return container;
    }

    public ActiveMQConnectionFactory createConnectionFactory(String url) {
        ActiveMQConnectionFactory acf = new ActiveMQConnectionFactory(url);
        acf.setCopyMessageOnSend(false);
        acf.setUseAsyncSend(false);
        acf.setDispatchAsync(true);
        acf.setUseCompression(false);
        acf.setOptimizeAcknowledge(false);
        acf.setOptimizedMessageDispatch(true);
        acf.setAlwaysSyncSend(true);
        return acf;
    }

    private static class NonPooledProducerTask
    implements Runnable {
        private final String queueName;
        private final ConnectionFactory cf;

        public NonPooledProducerTask(ConnectionFactory cf, String queueName) {
            this.cf = cf;
            this.queueName = queueName;
        }

        public void run() {
            try {
                JmsTemplate jmsTemplate = new JmsTemplate(this.cf);
                jmsTemplate.setDeliveryMode(1);
                jmsTemplate.setExplicitQosEnabled(true);
                jmsTemplate.setMessageIdEnabled(false);
                jmsTemplate.setMessageTimestampEnabled(false);
                jmsTemplate.afterPropertiesSet();
                final byte[] bytes = new byte[2048];
                Random r = new Random();
                r.nextBytes(bytes);
                Thread.sleep(2000L);
                final AtomicInteger count = new AtomicInteger();
                for (int i = 0; i < 10; ++i) {
                    jmsTemplate.send(this.queueName, new MessageCreator(){

                        public Message createMessage(Session session) throws JMSException {
                            BytesMessage message = session.createBytesMessage();
                            message.writeBytes(bytes);
                            message.setIntProperty("count", count.incrementAndGet());
                            message.setStringProperty("producer", "non-pooled");
                            return message;
                        }
                    });
                    LOG.info((Object)("Non-PooledProducer sent message: " + count.get()));
                }
            }
            catch (Throwable e) {
                LOG.error((Object)"Producer 1 is exiting", e);
            }
        }
    }

    private static class PooledProducerTask
    implements Runnable {
        private final String queueName;
        private final PooledConnectionFactory pcf;

        public PooledProducerTask(PooledConnectionFactory pcf, String queueName) {
            this.pcf = pcf;
            this.queueName = queueName;
        }

        public void run() {
            try {
                JmsTemplate jmsTemplate = new JmsTemplate((ConnectionFactory)this.pcf);
                jmsTemplate.setDeliveryMode(1);
                jmsTemplate.setExplicitQosEnabled(true);
                jmsTemplate.setMessageIdEnabled(false);
                jmsTemplate.setMessageTimestampEnabled(false);
                jmsTemplate.afterPropertiesSet();
                final byte[] bytes = new byte[2048];
                Random r = new Random();
                r.nextBytes(bytes);
                Thread.sleep(2000L);
                final AtomicInteger count = new AtomicInteger();
                for (int i = 0; i < 10; ++i) {
                    jmsTemplate.send(this.queueName, new MessageCreator(){

                        public Message createMessage(Session session) throws JMSException {
                            BytesMessage message = session.createBytesMessage();
                            message.writeBytes(bytes);
                            message.setIntProperty("count", count.incrementAndGet());
                            message.setStringProperty("producer", "pooled");
                            return message;
                        }
                    });
                    LOG.info((Object)("PooledProducer sent message: " + count.get()));
                }
            }
            catch (Throwable e) {
                LOG.error((Object)"Producer 1 is exiting", e);
            }
        }
    }

    private class TestMessageListener1
    implements MessageListener {
        private final long waitTime;

        public TestMessageListener1(long waitTime) {
            this.waitTime = waitTime;
        }

        public void onMessage(Message msg) {
            try {
                LOG.info((Object)("Listener1 Consumed message " + msg.getIntProperty("count")));
                AMQDeadlockTest3.this.messageCount.incrementAndGet();
                AMQDeadlockTest3.this.doneLatch.countDown();
                Thread.sleep(this.waitTime);
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

