/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.jms.Connection;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import junit.textui.TestRunner;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MBeanTest
extends EmbeddedBrokerTestSupport {
    private static final Log LOG = LogFactory.getLog(MBeanTest.class);
    private static boolean waitForKeyPress;
    protected MBeanServer mbeanServer;
    protected String domain = "org.apache.activemq";
    protected String clientID = "foo";
    protected Connection connection;
    protected boolean transacted;
    protected int authMode = 1;
    protected static final int MESSAGE_COUNT = 200;

    public static void main(String[] args) {
        waitForKeyPress = true;
        TestRunner.run(MBeanTest.class);
    }

    public void testMBeans() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
        this.assertQueueBrowseWorks();
        this.assertCreateAndDestroyDurableSubscriptions();
        this.assertConsumerCounts();
    }

    public void testMoveMessagesBySelector() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":Type=Queue,Destination=" + this.getDestinationString() + ",BrokerName=localhost");
        QueueViewMBean queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        String newDestination = "test.new.destination." + ((Object)((Object)this)).getClass() + "." + this.getName();
        queue.moveMatchingMessagesTo("counter > 2", newDestination);
        queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":Type=Queue,Destination=" + newDestination + ",BrokerName=localhost");
        queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        int movedSize = 197;
        MBeanTest.assertEquals((String)"Unexpected number of messages ", (long)movedSize, (long)queue.getQueueSize());
        queue.removeMatchingMessages("counter > 2");
        MBeanTest.assertEquals((String)("Should have no more messages in the queue: " + queueViewMBeanName), (long)0L, (long)queue.getQueueSize());
    }

    public void testCopyMessagesBySelector() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":Type=Queue,Destination=" + this.getDestinationString() + ",BrokerName=localhost");
        QueueViewMBean queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        String newDestination = "test.new.destination." + ((Object)((Object)this)).getClass() + "." + this.getName();
        long queueSize = queue.getQueueSize();
        queue.copyMatchingMessagesTo("counter > 2", newDestination);
        queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":Type=Queue,Destination=" + newDestination + ",BrokerName=localhost");
        queue = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        LOG.info("Queue: " + queueViewMBeanName + " now has: " + queue.getQueueSize() + " message(s)");
        MBeanTest.assertEquals((String)("Expected messages in a queue: " + queueViewMBeanName), (long)197L, (long)queue.getQueueSize());
        queue.removeMatchingMessages("counter > 2");
        MBeanTest.assertEquals((String)("Should have no more messages in the queue: " + queueViewMBeanName), (long)0L, (long)queue.getQueueSize());
    }

    protected void assertQueueBrowseWorks() throws Exception {
        Integer mbeancnt = this.mbeanServer.getMBeanCount();
        this.echo("Mbean count :" + mbeancnt);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":Type=Queue,Destination=" + this.getDestinationString() + ",BrokerName=localhost");
        this.echo("Create QueueView MBean...");
        QueueViewMBean proxy = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        long concount = proxy.getConsumerCount();
        this.echo("Consumer Count :" + concount);
        long messcount = proxy.getQueueSize();
        this.echo("current number of messages in the queue :" + messcount);
        CompositeData[] compdatalist = proxy.browse();
        if (compdatalist.length == 0) {
            MBeanTest.fail((String)"There is no message in the queue:");
        }
        String[] messageIDs = new String[compdatalist.length];
        for (int i = 0; i < compdatalist.length; ++i) {
            CompositeData cdata = compdatalist[i];
            if (i == 0) {
                this.echo("Columns: " + cdata.getCompositeType().keySet());
            }
            messageIDs[i] = (String)cdata.get("JMSMessageID");
            this.echo("message " + i + " : " + cdata.values());
        }
        TabularData table = proxy.browseAsTable();
        this.echo("Found tabular data: " + table);
        MBeanTest.assertTrue((String)"Table should not be empty!", (table.size() > 0 ? 1 : 0) != 0);
        MBeanTest.assertEquals((String)"Queue size", (long)200L, (long)proxy.getQueueSize());
        String messageID = messageIDs[0];
        String newDestinationName = "queue://dummy.test.cheese";
        this.echo("Attempting to copy: " + messageID + " to destination: " + newDestinationName);
        proxy.copyMessageTo(messageID, newDestinationName);
        MBeanTest.assertEquals((String)"Queue size", (long)200L, (long)proxy.getQueueSize());
        messageID = messageIDs[1];
        this.echo("Attempting to remove: " + messageID);
        proxy.removeMessage(messageID);
        MBeanTest.assertEquals((String)"Queue size", (long)199L, (long)proxy.getQueueSize());
        this.echo("Worked!");
    }

    protected void assertCreateAndDestroyDurableSubscriptions() throws Exception {
        ObjectName brokerName = this.assertRegisteredObjectName(this.domain + ":Type=Broker,BrokerName=localhost");
        this.echo("Create QueueView MBean...");
        BrokerViewMBean broker = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerName, BrokerViewMBean.class, true);
        broker.addTopic(this.getDestinationString());
        MBeanTest.assertEquals((String)"Durable subscriber count", (int)0, (int)broker.getDurableTopicSubscribers().length);
        String topicName = this.getDestinationString();
        String selector = null;
        ObjectName name1 = broker.createDurableSubscriber(this.clientID, "subscriber1", topicName, selector);
        broker.createDurableSubscriber(this.clientID, "subscriber2", topicName, selector);
        MBeanTest.assertEquals((String)"Durable subscriber count", (int)2, (int)broker.getDurableTopicSubscribers().length);
        MBeanTest.assertNotNull((String)"Should have created an mbean name for the durable subscriber!", (Object)name1);
        LOG.info("Created durable subscriber with name: " + name1);
        broker.destroyDurableSubscriber(this.clientID, "subscriber1");
        MBeanTest.assertEquals((String)"Durable subscriber count", (int)1, (int)broker.getDurableTopicSubscribers().length);
    }

    protected void assertConsumerCounts() throws Exception {
        ObjectName brokerName = this.assertRegisteredObjectName(this.domain + ":Type=Broker,BrokerName=localhost");
        BrokerViewMBean broker = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerName, BrokerViewMBean.class, true);
        broker.addTopic(this.getDestinationString() + "1");
        broker.addTopic(this.getDestinationString() + "2");
        ObjectName topicObjName1 = this.assertRegisteredObjectName(this.domain + ":Type=Topic,BrokerName=localhost,Destination=" + this.getDestinationString() + "1");
        ObjectName topicObjName2 = this.assertRegisteredObjectName(this.domain + ":Type=Topic,BrokerName=localhost,Destination=" + this.getDestinationString() + "2");
        TopicViewMBean topic1 = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, topicObjName1, TopicViewMBean.class, true);
        TopicViewMBean topic2 = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, topicObjName2, TopicViewMBean.class, true);
        MBeanTest.assertEquals((String)"topic1 Durable subscriber count", (long)0L, (long)topic1.getConsumerCount());
        MBeanTest.assertEquals((String)"topic2 Durable subscriber count", (long)0L, (long)topic2.getConsumerCount());
        String topicName = this.getDestinationString();
        String selector = null;
        broker.createDurableSubscriber(this.clientID, "topic1.subscriber1", topicName + "1", selector);
        broker.createDurableSubscriber(this.clientID, "topic2.subscriber1", topicName + "2", selector);
        MBeanTest.assertEquals((String)"topic1 Durable subscriber count", (long)1L, (long)topic1.getConsumerCount());
        MBeanTest.assertEquals((String)"topic2 Durable subscriber count", (long)1L, (long)topic2.getConsumerCount());
        broker.createDurableSubscriber(this.clientID, "topic1.subscriber2", topicName + "1", selector);
        MBeanTest.assertEquals((String)"topic1 Durable subscriber count", (long)2L, (long)topic1.getConsumerCount());
        MBeanTest.assertEquals((String)"topic2 Durable subscriber count", (long)1L, (long)topic2.getConsumerCount());
        broker.destroyDurableSubscriber(this.clientID, "topic1.subscriber1");
        MBeanTest.assertEquals((String)"topic1 Durable subscriber count", (long)1L, (long)topic1.getConsumerCount());
        MBeanTest.assertEquals((String)"topic2 Durable subscriber count", (long)1L, (long)topic2.getConsumerCount());
        broker.destroyDurableSubscriber(this.clientID, "topic2.subscriber1");
        MBeanTest.assertEquals((String)"topic1 Durable subscriber count", (long)1L, (long)topic1.getConsumerCount());
        MBeanTest.assertEquals((String)"topic2 Durable subscriber count", (long)0L, (long)topic2.getConsumerCount());
        broker.destroyDurableSubscriber(this.clientID, "topic1.subscriber2");
        MBeanTest.assertEquals((String)"topic1 Durable subscriber count", (long)0L, (long)topic1.getConsumerCount());
        MBeanTest.assertEquals((String)"topic2 Durable subscriber count", (long)0L, (long)topic2.getConsumerCount());
    }

    protected ObjectName assertRegisteredObjectName(String name) throws MalformedObjectNameException, NullPointerException {
        ObjectName objectName = new ObjectName(name);
        if (this.mbeanServer.isRegistered(objectName)) {
            this.echo("Bean Registered: " + objectName);
        } else {
            MBeanTest.fail((String)("Could not find MBean!: " + objectName));
        }
        return objectName;
    }

    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:61616";
        this.useTopic = false;
        super.setUp();
        this.mbeanServer = this.broker.getManagementContext().getMBeanServer();
    }

    protected void tearDown() throws Exception {
        if (waitForKeyPress) {
            System.out.println();
            System.out.println("Press enter to terminate the program.");
            System.out.println("In the meantime you can use your JMX console to view the current MBeans");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            reader.readLine();
        }
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        super.tearDown();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setDeleteAllMessagesOnStartup(true);
        answer.setUseJmx(true);
        answer.setPersistent(false);
        answer.addConnector(this.bindAddress);
        return answer;
    }

    protected void useConnection(Connection connection) throws Exception {
        connection.setClientID(this.clientID);
        connection.start();
        Session session = connection.createSession(this.transacted, this.authMode);
        this.destination = this.createDestination();
        MessageProducer producer = session.createProducer(this.destination);
        for (int i = 0; i < 200; ++i) {
            TextMessage message = session.createTextMessage("Message: " + i);
            message.setIntProperty("counter", i);
            producer.send(message);
        }
        Thread.sleep(1000L);
    }

    protected void echo(String text) {
        LOG.info(text);
    }
}

