/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.filebroker.FileBrokerException;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.NamiMessage;
import fi.csc.microarray.messaging.message.UrlMessage;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.UrlTransferUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class FileBrokerClient {
    private static final int URL_REQUEST_TIMEOUT = 30;
    private static final int FILE_AVAILABLE_TIMEOUT = 10;
    private static final Logger logger = Logger.getLogger(FileBrokerClient.class);
    private MessagingTopic urlTopic;
    private boolean useChunked = DirectoryLayout.getInstance().getConfiguration().getBoolean("messaging", "use-chunked-http");

    public FileBrokerClient(MessagingTopic urlTopic) throws JMSException {
        this.urlTopic = urlTopic;
    }

    public URL addFile(InputStream content, IOUtils.CopyProgressListener progressListener) throws FileBrokerException, JMSException, IOException {
        URL url = this.getNewUrl();
        if (url == null) {
            throw new FileBrokerException("New URL is null.");
        }
        logger.debug("uploading new file: " + url);
        UrlTransferUtil.uploadStream(url, content, this.useChunked, progressListener);
        logger.debug("successfully uploaded: " + url);
        return url;
    }

    public InputStream getFile(URL url) throws IOException {
        InputStream payload = null;
        payload = url.openStream();
        long waitStartTime = System.currentTimeMillis();
        int waitTime = 10;
        while (payload.available() < 1 && waitStartTime + 10000L > System.currentTimeMillis()) {
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            waitTime *= 2;
        }
        return payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkFile(URL url, long contentLength) throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            if (connection.getResponseCode() != 200) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            IOUtils.disconnectIfPossible(connection);
        }
        return true;
    }

    private URL getNewUrl() throws JMSException {
        logger.debug("getting new url");
        UrlMessageListener replyListener = new UrlMessageListener();
        this.urlTopic.sendReplyableMessage(new CommandMessage("url-request"), replyListener);
        URL url = replyListener.waitForReply(30L, TimeUnit.SECONDS);
        logger.debug("new url is: " + url);
        return url;
    }

    private class UrlMessageListener
    implements MessagingListener {
        private URL newUrl;
        private CountDownLatch latch = new CountDownLatch(1);

        private UrlMessageListener() {
        }

        public void onNamiMessage(NamiMessage msg) {
            if (msg instanceof UrlMessage) {
                UrlMessage urlMessage = (UrlMessage)msg;
                this.newUrl = urlMessage.getUrl();
                this.latch.countDown();
            }
        }

        public URL waitForReply(long timeout, TimeUnit unit) {
            try {
                this.latch.await(timeout, unit);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return this.newUrl;
        }
    }
}

