/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.security.CryptoKey;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AuthorisedUrlRepository {
    private static final int URL_LIFETIME_MINUTES = 10;
    private HashMap<URL, Date> repository = new HashMap();
    private Lock repositoryLock = new ReentrantLock();
    private String host;
    private int port;

    public AuthorisedUrlRepository(String host, int port) {
        this.host = host;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL createAuthorisedUrl() throws MalformedURLException {
        URL newUrl;
        this.repositoryLock.lock();
        try {
            String filename;
            do {
                filename = CryptoKey.generateRandom();
            } while (this.repository.containsKey(newUrl = new URL(this.host + ":" + this.port + "/" + filename)));
            this.repository.put(newUrl, new Date());
        }
        finally {
            this.repositoryLock.unlock();
        }
        return newUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAuthorised(URL url) {
        boolean contains = false;
        this.repositoryLock.lock();
        try {
            Iterator<URL> keyIterator = this.repository.keySet().iterator();
            while (keyIterator.hasNext()) {
                URL key = keyIterator.next();
                if (this.isDateValid(this.repository.get(key))) continue;
                keyIterator.remove();
            }
            contains = this.repository.containsKey(url);
        }
        finally {
            this.repositoryLock.unlock();
        }
        return contains;
    }

    public boolean checkFilenameSyntax(String filename) {
        return CryptoKey.validateKeySyntax(filename);
    }

    private boolean isDateValid(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(12, -10);
        return cal.getTime().before(date);
    }

    public String getRootUrl() {
        return this.host + ":" + this.port;
    }
}

