/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.client.visualisation.VisualisationUtilities;
import fi.csc.microarray.client.visualisation.methods.Scatterplot;
import fi.csc.microarray.client.visualisation.methods.SelectableChartPanel;
import fi.csc.microarray.databeans.DataBean;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Volcanoplot
extends Scatterplot
implements ActionListener,
PropertyChangeListener,
SelectableChartPanel.SelectionChangeListener {
    private static final String Y_AXIS_COLUMN_HEADER = "p.";
    private static final String X_AXIS_COLUMN_HEADER = "FC";
    private float ROUNDING_LIMIT;

    public Volcanoplot(VisualisationFrame frame) {
        super(frame);
    }

    @Override
    public JPanel createSettingsPanel() {
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new GridBagLayout());
        settingsPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
        this.xBox = new JComboBox();
        this.yBox = new JComboBox();
        this.useButton = new JButton("Draw");
        this.useButton.addActionListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.insets.set(10, 10, 10, 10);
        c.anchor = 18;
        c.fill = 2;
        c.weighty = 0.0;
        c.weightx = 1.0;
        settingsPanel.add((Component)new JLabel("Fold change "), c);
        ++c.gridy;
        settingsPanel.add((Component)this.xBox, c);
        ++c.gridy;
        settingsPanel.add((Component)new JLabel("p-value"), c);
        ++c.gridy;
        settingsPanel.add((Component)this.yBox, c);
        ++c.gridy;
        settingsPanel.add((Component)this.useButton, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        settingsPanel.add((Component)new JPanel(), c);
        this.xBox.addActionListener(this);
        this.yBox.addActionListener(this);
        return settingsPanel;
    }

    @Override
    protected void refreshAxisBoxes(DataBean data) {
        if (this.paramPanel == null) {
            throw new IllegalStateException("must call getParameterPanel first");
        }
        Visualisation.fillCompoBox(this.xBox, VisualisationUtilities.getVariablesFilteredInclusive(data, X_AXIS_COLUMN_HEADER, false));
        Visualisation.fillCompoBox(this.yBox, VisualisationUtilities.getVariablesFilteredInclusive(data, Y_AXIS_COLUMN_HEADER, false));
    }

    @Override
    public JComponent getVisualisation(DataBean data) throws Exception {
        this.data = data;
        this.refreshAxisBoxes(data);
        List<Visualisation.Variable> vars = this.getFrame().getVariables();
        if (vars != null && vars.size() == 2) {
            this.xBox.setSelectedItem(vars.get(0));
            this.yBox.setSelectedItem(vars.get(1));
        }
        this.xVar = (Visualisation.Variable)this.xBox.getSelectedItem();
        this.yVar = (Visualisation.Variable)this.yBox.getSelectedItem();
        Visualisation.PlotDescription description = new Visualisation.PlotDescription(data.getName(), "fold change", "-log(p)");
        NumberAxis domainAxis = new NumberAxis(description.xTitle);
        NumberAxis rangeAxis = new NumberAxis(description.yTitle);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setLinesVisible(false);
        renderer.setShapesVisible(true);
        renderer.setSeriesPaint(0, Color.green);
        renderer.setSeriesPaint(1, Color.red);
        renderer.setSeriesPaint(2, Color.black);
        renderer.setSeriesPaint(3, Color.lightGray);
        renderer.setShape(new Ellipse2D.Float(-2.0f, -2.0f, 4.0f, 4.0f));
        this.plot = new XYPlot(new XYSeriesCollection(), domainAxis, rangeAxis, renderer);
        this.updateSelectionsFromApplication(false);
        this.plot.getRangeAxis().setRange(new Range(0.0, -Math.log(this.ROUNDING_LIMIT)));
        JFreeChart chart = new JFreeChart(description.plotTitle, this.plot);
        chart.removeLegend();
        this.application.addPropertyChangeListener(this);
        this.selectableChartPanel = new SelectableChartPanel(chart, this);
        return this.selectableChartPanel;
    }

    private Iterator<Float> getXValueIterator() throws MicroarrayException {
        return this.data.queryFeatures(this.xVar.getExpression()).asFloats().iterator();
    }

    private Iterator<Float> getYValueIterator() throws MicroarrayException {
        return new YValueIterator();
    }

    @Override
    protected void updateXYSerieses() throws MicroarrayException {
        Iterator<Float> xValues = this.getXValueIterator();
        Iterator<Float> yValues = this.getYValueIterator();
        XYSeries greenSeries = new XYSeries((Comparable)((Object)""));
        XYSeries blackSeries = new XYSeries((Comparable)((Object)""));
        XYSeries redSeries = new XYSeries((Comparable)((Object)""));
        XYSeries selectedSeries = new XYSeries((Comparable)((Object)""));
        int row = 0;
        while (xValues.hasNext() && yValues.hasNext()) {
            boolean overXThreshold;
            float x = xValues.next().floatValue();
            float y = yValues.next().floatValue();
            boolean overYThreshold = (double)y >= -Math.log(0.05);
            boolean bl = overXThreshold = Math.abs(x) >= 1.0f;
            if (this.selectedIndexes.contains(row)) {
                selectedSeries.add(new XYDataItem(x, y));
            } else if (overYThreshold && overXThreshold) {
                if (x < 0.0f) {
                    greenSeries.add(new XYDataItem(x, y));
                } else {
                    redSeries.add(new XYDataItem(x, y));
                }
            } else {
                blackSeries.add(new XYDataItem(x, y));
            }
            ++row;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(greenSeries);
        dataset.addSeries(redSeries);
        dataset.addSeries(blackSeries);
        dataset.addSeries(selectedSeries);
        this.plot.setDataset(dataset);
    }

    @Override
    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        boolean isTabular = VisualisationMethod.SPREADSHEET.getHeadlessVisualiser().canVisualise(bean);
        return isTabular && this.hasRows(bean) && bean.queryFeatures("/column/p.*").exists() && bean.queryFeatures("/column/FC*").exists();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.useButton) {
            ArrayList<Visualisation.Variable> vars = new ArrayList<Visualisation.Variable>();
            vars.add((Visualisation.Variable)this.xBox.getSelectedItem());
            vars.add((Visualisation.Variable)this.yBox.getSelectedItem());
            this.application.setVisualisationMethod(new VisualisationMethodChangedEvent(this, VisualisationMethod.VOLCANOPLOT, vars, this.getFrame().getDatas(), this.getFrame().getType(), this.getFrame()));
        }
    }

    @Override
    public void selectionChanged(Rectangle2D.Double newSelection) {
        if (newSelection == null) {
            this.selectedIndexes.clear();
        } else {
            try {
                Iterator<Float> xValues = this.getXValueIterator();
                Iterator<Float> yValues = this.getYValueIterator();
                int i = 0;
                while (xValues.hasNext() && yValues.hasNext()) {
                    if (newSelection.contains(new Point2D.Double(xValues.next().floatValue(), yValues.next().floatValue()))) {
                        if (this.selectedIndexes.contains(i)) {
                            this.selectedIndexes.remove(i);
                        } else {
                            this.selectedIndexes.add(i);
                        }
                    }
                    ++i;
                }
            }
            catch (MicroarrayException e) {
                this.application.reportException(e);
            }
        }
        this.list.setSelectedRows(this.selectedIndexes, this, true, this.data);
        try {
            this.updateXYSerieses();
        }
        catch (MicroarrayException e) {
            this.application.reportException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class YValueIterator
    implements Iterator<Float> {
        private static final float DEFAULT_ROUNDING_LIMIT = 1.0E-4f;
        Iterator<Float> original;

        public YValueIterator() throws MicroarrayException {
            this.original = Volcanoplot.this.data.queryFeatures(Volcanoplot.this.yVar.getExpression()).asFloats().iterator();
            float min = Float.MAX_VALUE;
            while (this.original.hasNext()) {
                float y = this.original.next().floatValue();
                if (!(y < min) || !(y > 0.0f)) continue;
                min = y;
            }
            Volcanoplot.this.ROUNDING_LIMIT = (float)Math.pow(10.0, Math.floor(Math.log10(min)));
            if (Volcanoplot.this.ROUNDING_LIMIT <= 0.0f || Volcanoplot.this.ROUNDING_LIMIT > 1.0f) {
                Volcanoplot.this.ROUNDING_LIMIT = 1.0E-4f;
            }
            this.original = Volcanoplot.this.data.queryFeatures(Volcanoplot.this.yVar.getExpression()).asFloats().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.original.hasNext();
        }

        @Override
        public Float next() {
            float y = this.original.next().floatValue();
            if (y < Volcanoplot.this.ROUNDING_LIMIT) {
                y = Volcanoplot.this.ROUNDING_LIMIT;
            }
            return Float.valueOf((float)(-Math.log(y)));
        }

        @Override
        public void remove() {
            this.original.remove();
        }
    }
}

