/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dataimport.ImportItem;
import fi.csc.microarray.client.dataimport.ImportUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportSession {
    private Source source;
    private List<ImportItem> items;
    private String destinationFolder;
    private boolean useSameDescriptions;
    private boolean skipActionChooser;

    public ImportSession(Source source, File[] files, String destinationFolder, boolean skipActionChooser) {
        this(source, ImportSession.arrayToList(files), destinationFolder, skipActionChooser);
    }

    public ImportSession(Source source, List<File> files, String destinationFolder, boolean skipActionChooser) {
        this.source = source;
        this.items = ImportSession.initializeItems(files);
        this.destinationFolder = destinationFolder;
        this.useSameDescriptions = false;
        this.skipActionChooser = skipActionChooser;
    }

    private static List<ImportItem> initializeItems(List<File> files) {
        ArrayList<ImportItem> returnItems = new ArrayList<ImportItem>();
        for (int i = 0; i < files.size(); ++i) {
            ImportItem item = new ImportItem(files.get(i));
            if (ImportUtils.isFileSupported(files.get(i))) {
                item.setAction(ImportItem.Action.DIRECT);
            } else {
                item.setAction(ImportItem.Action.CUSTOM);
            }
            item.setType(Session.getSession().getDataManager().guessContentType(files.get(i)));
            returnItems.add(item);
        }
        return returnItems;
    }

    public List<ImportItem> getImportItems() {
        return this.items;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public String getDestinationFolder() {
        return this.destinationFolder;
    }

    public void setUseSameDescriptions(boolean useSameDescriptions) {
        this.useSameDescriptions = useSameDescriptions;
    }

    public boolean getUseSameDescriptions() {
        return this.useSameDescriptions;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public ImportItem getItemAtIndex(int index) {
        if (index >= this.getItemCount() || index < 0) {
            return null;
        }
        return this.items.get(index);
    }

    public boolean hasCustomFiles() {
        for (ImportItem item : this.items) {
            if (item.getAction() != ImportItem.Action.CUSTOM) continue;
            return true;
        }
        return false;
    }

    public List<File> getInputFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (ImportItem item : this.items) {
            files.add(item.getInput());
        }
        return files;
    }

    public List<File> getCustomFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (ImportItem item : this.items) {
            if (item.getAction() != ImportItem.Action.CUSTOM) continue;
            files.add(item.getInput());
        }
        return files;
    }

    public void setActionToItemIndex(int index, ImportItem.Action action) {
        this.items.get(index).setAction(action);
    }

    public static List<File> arrayToList(File[] files) {
        ArrayList<File> fileList = new ArrayList<File>();
        for (File file : files) {
            fileList.add(file);
        }
        return fileList;
    }

    public boolean isSkipActionChooser() {
        return this.skipActionChooser;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Source {
        FILES,
        FOLDER,
        URL,
        CLIPBOARD;

    }
}

