/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.auth;

import fi.csc.microarray.auth.LoginModuleBase;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.LookaheadStringReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFileLoginModule
extends LoginModuleBase {
    public static final DateFormat EXPIRATION_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final String DELIMETER_CHARACTER = ":";
    public static final String COMMENT_CHARACTER = "#";
    private static final Logger logger = Logger.getLogger(SimpleFileLoginModule.class);
    protected File passwdFile;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        String passwdFileName = (String)options.get("passwdFile");
        this.passwdFile = new File(passwdFileName);
        if (!this.passwdFile.exists()) {
            logger.error("Password file " + this.passwdFile.getAbsolutePath() + " not found, simple file login module not started.");
            throw new RuntimeException(this.passwdFile.getAbsolutePath() + " not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean authenticate(String username, char[] password) throws IOException {
        logger.debug(this.getClass().getName() + " authenticating " + username);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.passwdFile));
            String line = reader.readLine();
            while (line != null) {
                String readUsername;
                LookaheadStringReader tokens;
                if (line.trim().length() != 0 && !(tokens = new LookaheadStringReader(line)).lookahead().equals(COMMENT_CHARACTER) && (readUsername = tokens.readTo(DELIMETER_CHARACTER)).equals(username)) {
                    tokens.read();
                    StringBuffer readPassword = tokens.readToSB(DELIMETER_CHARACTER);
                    boolean match = true;
                    for (int i = 0; i < readPassword.length(); ++i) {
                        if (readPassword.length() != password.length || readPassword.charAt(i) != password[i]) {
                            match = false;
                        }
                        readPassword.setCharAt(i, '\u0000');
                    }
                    if (match) {
                        if (!tokens.isAtEnd() && tokens.lookahead().equals(DELIMETER_CHARACTER)) {
                            tokens.read();
                            String expiration = tokens.readTo(DELIMETER_CHARACTER);
                            if (expiration.trim().length() > 0) {
                                try {
                                    Date expirationDate = EXPIRATION_DATE_FORMAT.parse(expiration);
                                    if (new Date().after(expirationDate)) {
                                        match = false;
                                    }
                                }
                                catch (ParseException e) {
                                    logger.error("when authenticating " + username + " failed to parse exp. date: " + expiration);
                                    match = false;
                                }
                            }
                        }
                        if (match) {
                            boolean bl = true;
                            IOUtils.closeIfPossible(reader);
                            return bl;
                        }
                    }
                }
                line = reader.readLine();
            }
            IOUtils.closeIfPossible(reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeIfPossible(reader);
        }
        return false;
    }
}

