/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.ws.impl;

import fi.csc.microarray.analyser.ws.HtmlUtil;
import fi.csc.microarray.analyser.ws.ResultTableCollector;
import fi.csc.microarray.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EnfinWsUtils {
    public static void main(String[] args) throws SAXException, ParserConfigurationException, TransformerException, SOAPException, IOException {
        String[] probes = new String[]{"204704_s_at", "221589_s_at", "206065_s_at", "209459_s_at", "209460_at", "206024_at", "205719_s_at", "205892_s_at", "202036_s_at", "206054_at", "209443_at"};
        ResultTableCollector intactAnnotations = EnfinWsUtils.queryIntact(probes);
        HtmlUtil.writeHtmlTable(intactAnnotations, new String[]{"Interaction", "Participants"}, "Enfin IntAct annotation", new FileOutputStream("intact.html"));
        ResultTableCollector reactomeAnnotations = EnfinWsUtils.queryReactome(probes);
        HtmlUtil.writeHtmlTable(reactomeAnnotations, new String[]{"Pathway", "Participating proteins"}, "Reactome pathway associations (via Enfin WS)", new FileOutputStream("reactome.html"));
    }

    public static ResultTableCollector queryIntact(String[] probes) throws SOAPException, MalformedURLException, SAXException, IOException, ParserConfigurationException, TransformerException {
        Document uniprotResponse = EnfinWsUtils.queryUniprotIds(probes);
        SOAPMessage intactSoapMessage = EnfinWsUtils.initialiseSoapMessage();
        SOAPBody intactSoapBody = EnfinWsUtils.initialiseSoapBody(intactSoapMessage);
        EnfinWsUtils.attachEnfinXml(intactSoapBody, EnfinWsUtils.fetchEnfinXml(uniprotResponse), "findPartners", "http://ebi.ac.uk/enfin/core/web/services/intact");
        Document intactResponse = EnfinWsUtils.sendSoapMessage(intactSoapMessage, new URL("http://www.ebi.ac.uk/enfin-srv/encore/intact/service"));
        return EnfinWsUtils.collectAnnotations(intactResponse, new AnnotationIdentifier(){

            public boolean isAnnotation(Element setElement) {
                NodeList names = setElement.getElementsByTagName("names");
                return names.getLength() > 0 && "IntAct interaction".equals(names.item(0).getChildNodes().item(0).getTextContent());
            }
        }, new AnnotationNameFinder(){

            public String findAnnotationName(Element setElement) {
                Element primaryRef = (Element)setElement.getElementsByTagName("xrefs").item(0).getChildNodes().item(0);
                return primaryRef.getAttribute("id");
            }
        }, "Interaction", "Participants");
    }

    public static ResultTableCollector queryReactome(String[] probes) throws SOAPException, MalformedURLException, SAXException, IOException, ParserConfigurationException, TransformerException {
        Document uniprotResponse = EnfinWsUtils.queryUniprotIds(probes);
        SOAPMessage intactSoapMessage = EnfinWsUtils.initialiseSoapMessage();
        SOAPBody intactSoapBody = EnfinWsUtils.initialiseSoapBody(intactSoapMessage);
        EnfinWsUtils.attachEnfinXml(intactSoapBody, EnfinWsUtils.fetchEnfinXml(uniprotResponse), "findPath", "http://ebi.ac.uk/enfin/core/web/services/reactome");
        Document reactomeResponse = EnfinWsUtils.sendSoapMessage(intactSoapMessage, new URL("http://www.ebi.ac.uk/enfin-srv/encore/reactome/service"));
        return EnfinWsUtils.collectAnnotations(reactomeResponse, new AnnotationIdentifier(){

            public boolean isAnnotation(Element setElement) {
                NodeList setTypes = setElement.getElementsByTagName("setType");
                return setTypes.getLength() > 0 && "Reactome".equals(((Element)setTypes.item(0)).getAttribute("db"));
            }
        }, new AnnotationNameFinder(){

            public String findAnnotationName(Element setElement) {
                Element fullName = (Element)setElement.getElementsByTagName("names").item(0).getChildNodes().item(0);
                return fullName.getTextContent();
            }
        }, "Pathway", "Participating proteins");
    }

    private static Document queryUniprotIds(String[] probes) throws SOAPException, SAXException, IOException, ParserConfigurationException, MalformedURLException {
        SOAPMessage probeSoapMessage = EnfinWsUtils.initialiseSoapMessage();
        SOAPBody probeSoapBody = EnfinWsUtils.initialiseSoapBody(probeSoapMessage);
        SOAPElement probeEntries = EnfinWsUtils.createOperation(probeSoapBody, "docFromAffyList", "http://ebi.ac.uk/enfin/core/web/services/utility");
        for (String probe : probes) {
            SOAPElement arg = probeEntries.addChildElement("parameter");
            arg.setTextContent(probe);
        }
        Document probeResponse = EnfinWsUtils.sendSoapMessage(probeSoapMessage, new URL("http://www.ebi.ac.uk/enfin-srv/encore/utility/service"));
        SOAPMessage uniprotSoapMessage = EnfinWsUtils.initialiseSoapMessage();
        SOAPBody uniprotSoapBody = EnfinWsUtils.initialiseSoapBody(uniprotSoapMessage);
        EnfinWsUtils.attachEnfinXml(uniprotSoapBody, EnfinWsUtils.fetchEnfinXml(probeResponse), "mapAffy2UniProt", "http://ebi.ac.uk/enfin/core/web/services/affy2uniprot");
        Document uniprotResponse = EnfinWsUtils.sendSoapMessage(uniprotSoapMessage, new URL("http://www.ebi.ac.uk/enfin-srv/encore/affy2uniprot/service"));
        return uniprotResponse;
    }

    private static Document fetchEnfinXml(Document response) throws ParserConfigurationException {
        Document document = XmlUtil.getInstance().newDocument();
        document.appendChild(document.importNode(response.getDocumentElement().getElementsByTagNameNS("http://ebi.ac.uk/enfin/core/model", "entries").item(0), true));
        return document;
    }

    private static ResultTableCollector collectAnnotations(Document response, AnnotationIdentifier annotationIdentifier, AnnotationNameFinder annotationNameFinder, String annotationColumnName, String participantColumnName) {
        ResultTableCollector annotationCollector = new ResultTableCollector();
        NodeList childNodes = response.getDocumentElement().getChildNodes().item(0).getChildNodes().item(0).getChildNodes().item(0).getChildNodes().item(0).getChildNodes();
        HashMap<String, String> moleculeMap = new HashMap<String, String>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!"molecule".equals(childNodes.item(i).getNodeName())) continue;
            Element molecule = (Element)childNodes.item(i);
            String moleculeId = molecule.getAttribute("id");
            Element primaryRef = (Element)molecule.getElementsByTagName("xrefs").item(0).getChildNodes().item(0);
            String moleculeName = primaryRef.getAttribute("id");
            moleculeMap.put(moleculeId, moleculeName);
        }
        int index = 0;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element set;
            if (!"set".equals(childNodes.item(i).getNodeName()) || !annotationIdentifier.isAnnotation(set = (Element)childNodes.item(i))) continue;
            String annotationName = annotationNameFinder.findAnnotationName(set);
            annotationCollector.addAnnotation(index, annotationColumnName, annotationName);
            String participantValue = "";
            NodeList participants = set.getElementsByTagName("participant");
            for (int p = 0; p < participants.getLength(); ++p) {
                Element participant = (Element)participants.item(p);
                String moleculeName = (String)moleculeMap.get(participant.getAttribute("moleculeRef"));
                participantValue = participantValue + " " + moleculeName;
            }
            annotationCollector.addAnnotation(index, participantColumnName, participantValue);
            ++index;
        }
        return annotationCollector;
    }

    private static Document sendSoapMessage(SOAPMessage soapMessage, URL endpoint) throws SAXException, IOException, ParserConfigurationException, SOAPException {
        soapMessage.saveChanges();
        SOAPConnectionFactory connectionFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection soapConnection = connectionFactory.createConnection();
        SOAPMessage resp = soapConnection.call(soapMessage, endpoint);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        resp.writeTo(out);
        soapConnection.close();
        return XmlUtil.getInstance().parseReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
    }

    private static SOAPBody initialiseSoapBody(SOAPMessage message) throws SOAPException {
        SOAPPart soapPart = message.getSOAPPart();
        SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
        return soapEnvelope.getBody();
    }

    private static SOAPMessage initialiseSoapMessage() throws SOAPException {
        MessageFactory mf = MessageFactory.newInstance();
        return mf.createMessage();
    }

    private static void attachEnfinXml(SOAPBody soapBody, Document enfinXml, String operation, String operationNamespace) throws SOAPException, ParserConfigurationException {
        Document document = XmlUtil.getInstance().newDocument();
        document.appendChild(document.createElementNS(operationNamespace, operation));
        document.getDocumentElement().appendChild(document.importNode(enfinXml.getDocumentElement(), true));
        soapBody.addDocument(document);
    }

    private static SOAPElement createOperation(SOAPBody soapBody, String operation, String operationNamespace) throws SOAPException {
        soapBody.addNamespaceDeclaration("oper", operationNamespace);
        SOAPElement elementFindPartners = soapBody.addChildElement(operation, "oper");
        elementFindPartners.addNamespaceDeclaration("model", "http://ebi.ac.uk/enfin/core/model");
        return elementFindPartners;
    }

    static interface AnnotationNameFinder {
        public String findAnnotationName(Element var1);
    }

    static interface AnnotationIdentifier {
        public boolean isAnnotation(Element var1);
    }
}

