/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.ws;

import fi.csc.microarray.analyser.ws.ResultTableCollector;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class HtmlUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeHtmlTable(ResultTableCollector annotations, String[] columns, String title, File output) throws FileNotFoundException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(output);
            HtmlUtil.writeHtmlTable(annotations, columns, title, out);
        }
        catch (Throwable throwable) {
            IOUtils.closeIfPossible(out);
            throw throwable;
        }
        IOUtils.closeIfPossible(out);
    }

    public static void writeHtmlTable(ResultTableCollector annotations, String[] columns, String title, OutputStream outputStream) throws FileNotFoundException {
        int i;
        String[][] table = annotations.asTable(columns);
        HtmlTemplate out = new HtmlTemplate(new PrintWriter(outputStream));
        out.openDocument(title);
        out.heading(title);
        out.openTable();
        out.openRow();
        for (i = 0; i < columns.length; ++i) {
            String name = columns[i].contains(":") ? columns[i].split(":")[1] : columns[i];
            name = Strings.separateUppercaseChars(Strings.startWithUppercase(name), "-");
            name = name.replaceAll("_", " ");
            out.headerCell(name);
        }
        out.closeRow();
        for (i = 0; i < table.length; ++i) {
            out.openRow();
            for (int j = 0; j < table[i].length; ++j) {
                out.cell(table[i][j]);
            }
            out.closeRow();
        }
        out.closeTable();
        out.closeDocument();
        out.close();
    }

    private static class HtmlTemplate {
        final String css = "<style type=\"text/css\">\ntable {\n\tborder-width: 1px 1px 1px 1px;\n\tborder-spacing: 2px;\n\tborder-style: outset outset outset outset;\n\tborder-color: black black black black;\n\tborder-collapse: separate;\n\tbackground-color: white;\n}\ntable th {\n\tborder-width: 1px 1px 1px 1px;\n\tpadding: 1px 1px 1px 1px;\n\tborder-style: inset inset inset inset;\n\tborder-color: gray gray gray gray;\n\tbackground-color: white;\n\t-moz-border-radius: 0px 0px 0px 0px;\n}\ntable td {\n\tborder-width: 1px 1px 1px 1px;\n\tpadding: 1px 1px 1px 1px;\n\tborder-style: inset inset inset inset;\n\tborder-color: gray gray gray gray;\n\tbackground-color: white;\n\t-moz-border-radius: 0px 0px 0px 0px;\n}\n</style>\n";
        PrintWriter out;

        public HtmlTemplate(PrintWriter out) {
            this.out = out;
        }

        public void openDocument(String title) {
            this.out.println("<html>");
            this.out.println("<head>");
            this.out.println("<style type=\"text/css\">\ntable {\n\tborder-width: 1px 1px 1px 1px;\n\tborder-spacing: 2px;\n\tborder-style: outset outset outset outset;\n\tborder-color: black black black black;\n\tborder-collapse: separate;\n\tbackground-color: white;\n}\ntable th {\n\tborder-width: 1px 1px 1px 1px;\n\tpadding: 1px 1px 1px 1px;\n\tborder-style: inset inset inset inset;\n\tborder-color: gray gray gray gray;\n\tbackground-color: white;\n\t-moz-border-radius: 0px 0px 0px 0px;\n}\ntable td {\n\tborder-width: 1px 1px 1px 1px;\n\tpadding: 1px 1px 1px 1px;\n\tborder-style: inset inset inset inset;\n\tborder-color: gray gray gray gray;\n\tbackground-color: white;\n\t-moz-border-radius: 0px 0px 0px 0px;\n}\n</style>\n");
            this.out.println("<title>" + title + "</title>");
            this.out.println("</head>");
        }

        public void closeDocument() {
            this.out.println("</html>");
        }

        public void close() {
            this.out.close();
        }

        public void openTable() {
            this.out.println("<table>");
        }

        public void closeTable() {
            this.out.println("</table>");
        }

        public void openRow() {
            this.out.println("<tr>");
        }

        public void closeRow() {
            this.out.println("</tr>");
        }

        public void headerCell(String name) {
            this.out.println("<th>" + name + "</th>");
        }

        public void cell(String data) {
            this.out.println("<td>" + data + "</td>");
        }

        public void heading(String heading) {
            this.out.println("<h1>" + heading + "</h1>");
        }
    }
}

