/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.analyser.AnalysisDescription;
import fi.csc.microarray.analyser.AnalysisJob;
import fi.csc.microarray.analyser.ResultCallback;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.util.Files;
import fi.csc.microarray.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class OnDiskAnalysisJobBase
extends AnalysisJob {
    private static final Logger logger = Logger.getLogger(OnDiskAnalysisJobBase.class);
    protected File jobWorkDir;

    public void construct(JobMessage inputMessage, AnalysisDescription analysis, ResultCallback resultHandler) {
        super.construct(inputMessage, analysis, resultHandler);
        this.jobWorkDir = new File(resultHandler.getWorkDir(), this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preExecute() throws Exception {
        this.cancelCheck();
        super.preExecute();
        this.updateStateDetail("transferring input data", true);
        if (!this.jobWorkDir.mkdir()) {
            throw new IOException("Could not create work dir: " + this.jobWorkDir.toString());
        }
        for (String fileName : this.inputMessage.payloadNames()) {
            File outputFile;
            this.cancelCheck();
            URL inputUrl = this.inputMessage.getPayload(fileName);
            BufferedInputStream inputStream = null;
            BufferedOutputStream fileStream = null;
            try {
                inputStream = new BufferedInputStream(this.resultHandler.getFileBrokerClient().getFile(inputUrl));
                outputFile = new File(this.jobWorkDir, fileName);
                fileStream = new BufferedOutputStream(new FileOutputStream(outputFile));
                IOUtils.copy(inputStream, fileStream);
            }
            catch (Throwable throwable) {
                IOUtils.closeIfPossible(inputStream);
                IOUtils.closeIfPossible(fileStream);
                throw throwable;
            }
            IOUtils.closeIfPossible(inputStream);
            IOUtils.closeIfPossible(fileStream);
            logger.debug("created input file: " + outputFile.getName() + " " + outputFile.length());
        }
    }

    protected void postExecute() throws Exception {
        this.updateStateDetail("transferring output data", true);
        this.cancelCheck();
        List<String> outputFileNames = this.analysis.getOutputFiles();
        for (String fileName : outputFileNames) {
            this.cancelCheck();
            File outputFile = new File(this.jobWorkDir, fileName);
            URL url = this.resultHandler.getFileBrokerClient().addFile(new FileInputStream(outputFile), null);
            this.outputMessage.addPayload(fileName, url);
            logger.debug("transferred output file: " + fileName);
        }
        super.postExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp() {
        try {
            if (this.resultHandler.shouldSweepWorkDir()) {
                Files.delTree(this.jobWorkDir);
            }
        }
        catch (Exception e) {
            logger.error("Error when cleaning up job work dir.", e);
        }
        finally {
            super.cleanUp();
        }
    }
}

